/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.user.PermittedPrincipal;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalProjectSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalRepositorySearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalSearchRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ScopeType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class PermittedPrincipalSearchQueryHelper {
    private final ImmutableList.Builder<String> filterPredicates;
    private final ImmutableMap.Builder<String, Object> queryParameters;
    private final ImmutableList.Builder<String> scopePredicates;
    private final Session session;

    public PermittedPrincipalSearchQueryHelper(@Nonnull Session session, @Nonnull PermittedPrincipalSearchRequest searchRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest");
        this.session = Objects.requireNonNull(session, "session");
        this.filterPredicates = new ImmutableList.Builder();
        this.queryParameters = new ImmutableMap.Builder();
        this.scopePredicates = new ImmutableList.Builder();
        searchRequest.accept((PermittedPrincipalSearchRequest.Visitor)new PermittedPrincipalSearchRequest.Visitor<Void>(){

            public Void visit(@Nonnull PermittedPrincipalProjectSearchRequest request) {
                Set scopes = request.getScopes();
                if (scopes.isEmpty()) {
                    scopes = ImmutableSet.of((Object)ScopeType.GLOBAL, (Object)ScopeType.PROJECT);
                }
                PermittedPrincipalSearchQueryHelper.this.buildScopePredicates(scopes, request.getProject(), null);
                return null;
            }

            public Void visit(@Nonnull PermittedPrincipalRepositorySearchRequest request) {
                Set scopes = request.getScopes();
                if (scopes.isEmpty()) {
                    scopes = ImmutableSet.of((Object)ScopeType.GLOBAL, (Object)ScopeType.PROJECT, (Object)ScopeType.REPOSITORY);
                }
                Repository repository = request.getRepository();
                PermittedPrincipalSearchQueryHelper.this.buildScopePredicates(scopes, repository.getProject(), repository);
                return null;
            }
        });
        this.maybeFilterByType(searchRequest);
        this.maybeFilterByPermissions(searchRequest);
    }

    @Nonnull
    public Query<PermittedPrincipal> build() {
        Query query = this.session.createQuery(this.buildHql(), PermittedPrincipal.class);
        for (Map.Entry parameterEntry : this.queryParameters.build().entrySet()) {
            if (parameterEntry.getValue() instanceof Collection) {
                query.setParameterList((String)parameterEntry.getKey(), (Collection)parameterEntry.getValue());
                continue;
            }
            query.setParameter((String)parameterEntry.getKey(), parameterEntry.getValue());
        }
        return query;
    }

    private String buildHql() {
        String scopeHql = this.scopePredicates.build().stream().map(scope -> "(" + scope + ")").collect(Collectors.joining(" or "));
        String filterHql = this.filterPredicates.build().stream().map(filter -> "(" + filter + ")").collect(Collectors.joining(" and "));
        StringBuilder result = new StringBuilder("select new com.atlassian.stash.internal.user.InternalPermittedPrincipal(p) from InternalScopedPermission p left join p.user where (p.group is not null or p.user.class <> InternalServiceUser) and (" + scopeHql + ") ");
        if (!filterHql.isEmpty()) {
            result.append("and (" + filterHql + ") ");
        }
        return result.append("order by coalesce(p.user.username, p.group) asc, p.permission asc").toString();
    }

    private void buildScopePredicates(Set<ScopeType> scopes, Project project, Repository repository) {
        if (scopes.contains(ScopeType.GLOBAL)) {
            this.scopePredicates.add((Object)"p.class = InternalGlobalPermission and p.permission not in (:excludedGlobalPermissions)");
            this.queryParameters.put((Object)"excludedGlobalPermissions", (Object)ImmutableSet.of((Object)Permission.LICENSED_USER, (Object)Permission.PROJECT_CREATE));
        }
        if (scopes.contains(ScopeType.PROJECT) && project != null) {
            this.scopePredicates.add((Object)"p.class = InternalProjectPermission and p.project.id = :projectId");
            this.queryParameters.put((Object)"projectId", (Object)project.getId());
        }
        if (scopes.contains(ScopeType.REPOSITORY) && repository != null) {
            this.scopePredicates.add((Object)"p.class = InternalRepositoryPermission and p.repository.id = :repositoryId");
            this.queryParameters.put((Object)"repositoryId", (Object)repository.getId());
        }
    }

    private void maybeFilterByPermissions(PermittedPrincipalSearchRequest searchRequest) {
        Set permissions = searchRequest.getPermissions();
        if (!permissions.isEmpty()) {
            this.filterPredicates.add((Object)"p.permission in (:permissions)");
            this.queryParameters.put((Object)"permissions", (Object)permissions);
        }
    }

    private void maybeFilterByType(PermittedPrincipalSearchRequest searchRequest) {
        searchRequest.getPrincipalType().ifPresent(principalType -> {
            switch (principalType) {
                case GROUP: {
                    this.filterPredicates.add((Object)"p.group is not null");
                    break;
                }
                case USER: {
                    this.filterPredicates.add((Object)"p.user.username is not null");
                }
            }
        });
    }
}

