/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class LikeQueryHelper {
    public static final char ESCAPE_CHAR = '!';
    private static final Pattern BASE_LIKE_CONTROL_CHARS_PATTERN = Pattern.compile("([!%_])");
    private static final Pattern EXTENDED_LIKE_CONTROL_CHARS_PATTERN = Pattern.compile("([!%_\\[])");

    private LikeQueryHelper() {
        throw new UnsupportedOperationException("Utility classes should not be instantiated");
    }

    public static String matchesAnywhere(Session session, String substring) {
        return "%" + LikeQueryHelper.escape(session, substring) + "%";
    }

    public static String matchesEnd(Session session, String substring) {
        return "%" + LikeQueryHelper.escape(session, substring);
    }

    public static String matchesExact(Session session, String substring) {
        return LikeQueryHelper.escape(session, substring);
    }

    public static String matchesStart(Session session, String substring) {
        return LikeQueryHelper.escape(session, substring) + "%";
    }

    private static String escape(Session session, String substring) {
        return LikeQueryHelper.getControlCharPattern(session.getSessionFactory()).matcher(substring).replaceAll("!$1");
    }

    private static Pattern getControlCharPattern(SessionFactory factory) {
        Dialect dialect;
        if (factory instanceof SessionFactoryImplementor && (dialect = ((SessionFactoryImplementor)factory).getJdbcServices().getDialect()) instanceof SQLServerDialect) {
            return EXTENDED_LIKE_CONTROL_CHARS_PATTERN;
        }
        return BASE_LIKE_CONTROL_CHARS_PATTERN;
    }
}

