/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import com.atlassian.bitbucket.util.Operation;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.BaseStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NumberBuffer {
    private NumberBuffer() {
        throw new UnsupportedOperationException("Utility classes should not be instantiated");
    }

    @Nonnull
    public static IntStream buffer(@Nonnull IntStream intStream) {
        IntegerCompressedInMemoryBuffer bufferStrategy = new IntegerCompressedInMemoryBuffer();
        bufferStrategy.start();
        try (IntStream ignored = intStream;){
            intStream.forEach(bufferStrategy::add);
        }
        return (IntStream)bufferStrategy.stream();
    }

    @Nonnull
    public static LongStream buffer(@Nonnull LongStream longStream) {
        LongCompressedInMemoryBuffer bufferStrategy = new LongCompressedInMemoryBuffer();
        bufferStrategy.start();
        try (LongStream ignored = longStream;){
            longStream.forEach(bufferStrategy::add);
        }
        return (LongStream)bufferStrategy.stream();
    }

    private static <T> boolean executeAction(Consumer<T> action, Operation<T, IOException> operation) {
        try {
            action.accept(operation.perform());
            return true;
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Function<Operation<Integer, IOException>, IntStream> intStream() {
        return operation -> StreamSupport.intStream(new Spliterators.AbstractIntSpliterator(0L, 0, (Operation)operation){
            final /* synthetic */ Operation val$operation;
            {
                this.val$operation = operation;
                super(est, additionalCharacteristics);
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                return NumberBuffer.executeAction(action::accept, this.val$operation);
            }
        }, false);
    }

    private static Function<Operation<Long, IOException>, LongStream> longStream() {
        return operation -> StreamSupport.longStream(new Spliterators.AbstractLongSpliterator(0L, 0, (Operation)operation){
            final /* synthetic */ Operation val$operation;
            {
                this.val$operation = operation;
                super(est, additionalCharacteristics);
            }

            @Override
            public boolean tryAdvance(LongConsumer action) {
                return NumberBuffer.executeAction(action::accept, this.val$operation);
            }
        }, false);
    }

    private static class IntegerCompressedInMemoryBuffer
    extends CompressedInMemoryBuffer<Integer, IntStream> {
        IntegerCompressedInMemoryBuffer() {
            super(DataInputStream::readInt, DataOutputStream::writeInt, NumberBuffer.intStream());
        }
    }

    static interface BufferStrategy<T, R extends BaseStream<T, R>> {
        public void add(T var1);

        public void finish();

        public void start();

        public R stream();
    }

    private static class LongCompressedInMemoryBuffer
    extends CompressedInMemoryBuffer<Long, LongStream> {
        LongCompressedInMemoryBuffer() {
            super(DataInputStream::readLong, DataOutputStream::writeLong, NumberBuffer.longStream());
        }
    }

    private static class CompressedInMemoryBuffer<T, R extends BaseStream<T, R>>
    implements BufferStrategy<T, R> {
        private final IoFunction<DataInputStream, T> reader;
        private final Function<Operation<T, IOException>, R> streamer;
        private final IoBiConsumer<DataOutputStream, T> writer;
        private DataOutputStream dataOut;
        private ByteArrayOutputStream out;

        CompressedInMemoryBuffer(IoFunction<DataInputStream, T> reader, IoBiConsumer<DataOutputStream, T> writer, Function<Operation<T, IOException>, R> streamer) {
            this.reader = reader;
            this.writer = writer;
            this.streamer = streamer;
        }

        @Override
        public void add(T value) {
            try {
                this.writer.accept(this.dataOut, (DataOutputStream)value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void finish() {
            try {
                this.dataOut.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void start() {
            try {
                this.out = new ByteArrayOutputStream();
                this.dataOut = new DataOutputStream(new GZIPOutputStream(this.out));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public R stream() {
            this.finish();
            try {
                DataInputStream dataIn = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(this.out.toByteArray())));
                return (R)((BaseStream)this.streamer.apply(() -> this.reader.apply(dataIn))).onClose(() -> {
                    try {
                        this.out = null;
                        this.dataOut = null;
                        dataIn.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @FunctionalInterface
    static interface IoFunction<T, U> {
        public U apply(T var1) throws IOException;
    }

    @FunctionalInterface
    static interface IoBiConsumer<T, U> {
        public void accept(T var1, U var2) throws IOException;
    }
}

