/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.watcher;

import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherMapping;
import com.atlassian.stash.internal.watcher.WatcherMappingDao;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Repository(value="watcherMappingDao")
public class HibernateWatcherMappingDao
extends AbstractHibernateDao<Long, InternalWatcherMapping>
implements WatcherMappingDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.desc((String)"id"));

    @Autowired
    public HibernateWatcherMappingDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<InternalWatcherMapping> findByWatchable(@Nonnull InternalWatchable watchable, boolean transitive, @Nonnull PageRequest pageRequest) {
        InternalRepository repository;
        Map<String, Object> properties = HibernateWatcherMappingDao.toProperties(watchable);
        if (transitive && !Objects.equals(repository = watchable.getScopeRepository(), watchable)) {
            properties.put("repositoryId", repository.getId());
            properties.put("repositoryType", 3);
            return this.pageQuery((Query)this.session().createNativeQuery("(SELECT w.id, w.user_id, w.watchable_id, w.watchable_type FROM sta_watcher w WHERE w.watchable_id = :watchableId AND w.watchable_type = :watchableType) UNION (SELECT tw.id, tw.user_id, tw.watchable_id, tw.watchable_type FROM sta_watcher tw WHERE tw.watchable_id = :repositoryId AND tw.watchable_type = :repositoryType AND tw.user_id NOT IN (SELECT user_id FROM sta_watcher WHERE watchable_id = :watchableId AND watchable_type = :watchableType)) ORDER BY id", InternalWatcherMapping.class).setProperties(properties), pageRequest);
        }
        return this.pageQuery(this.session().createQuery("FROM InternalWatcherMapping WHERE watchableId = :watchableId AND watchableType = :watchableType ORDER BY id").setProperties(properties), pageRequest);
    }

    @Nonnull
    public Optional<InternalWatcherMapping> findByWatchableAndUser(@Nonnull InternalWatchable watchable, @Nonnull InternalApplicationUser user) {
        return Optional.ofNullable((InternalWatcherMapping)this.session().createQuery("FROM InternalWatcherMapping WHERE watchableId = :watchableId AND watchableType = :watchableType AND user.id = :userId").setProperties(HibernateWatcherMappingDao.toProperties(watchable, user)).uniqueResult());
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private static Map<String, Object> toProperties(InternalWatchable watchable) {
        return HibernateWatcherMappingDao.toProperties(watchable, null);
    }

    private static Map<String, Object> toProperties(InternalWatchable watchable, InternalApplicationUser user) {
        Map properties = (Map)watchable.accept((WatchableVisitor)new WatchableVisitor<Map<String, Object>>(){

            public Map<String, Object> visit(@Nonnull CommitDiscussion discussion) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("watchableId", ((InternalCommitDiscussion)discussion).getId());
                properties.put("watchableType", 2);
                return properties;
            }

            public Map<String, Object> visit(@Nonnull PullRequest pullRequest) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("watchableId", ((InternalPullRequest)pullRequest).getGlobalId());
                properties.put("watchableType", 1);
                return properties;
            }

            public Map<String, Object> visit(@Nonnull Repository repository) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("watchableId", Long.valueOf(repository.getId()));
                properties.put("watchableType", 3);
                return properties;
            }
        });
        if (user != null) {
            properties.put("userId", user.getId());
        }
        return properties;
    }
}

