/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.dmz.pull.reviewer.DmzReviewerGroupService;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.defaultreviewers.AbstractDefaultReviewersScopeVisitor;
import com.atlassian.bitbucket.internal.defaultreviewers.PullRequestConditionService;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.AoPullRequestCondition;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.AoReviewer;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.PullRequestConditionDao;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.ReviewerType;
import com.atlassian.bitbucket.internal.defaultreviewers.event.PullRequestConditionCreatedEvent;
import com.atlassian.bitbucket.internal.defaultreviewers.event.PullRequestConditionDeletedEvent;
import com.atlassian.bitbucket.internal.defaultreviewers.event.PullRequestConditionUpdatedEvent;
import com.atlassian.bitbucket.internal.defaultreviewers.model.PullRequestCondition;
import com.atlassian.bitbucket.internal.defaultreviewers.model.SimplePullRequestCondition;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectSupplier;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.pull.reviewer.NoSuchReviewerGroupException;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProviderRegistry;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultPullRequestConditionService
implements PullRequestConditionService {
    private static final int MAX_PAGE_SIZE = 100;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final ProjectSupplier projectSupplier;
    private final PullRequestConditionDao pullRequestConditionDao;
    private final RefMatcherProviderRegistry refMatcherProviderRegistry;
    private final RepositorySupplier repositorySupplier;
    private final DmzReviewerGroupService reviewerGroupService;
    private final UserService userService;

    public DefaultPullRequestConditionService(EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, PullRequestConditionDao pullRequestConditionDao, RefMatcherProviderRegistry refMatcherProviderRegistry, DmzReviewerGroupService reviewerGroupService, RepositorySupplier repositorySupplier, ProjectSupplier projectSupplier, UserService userService) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.reviewerGroupService = reviewerGroupService;
        this.projectSupplier = projectSupplier;
        this.pullRequestConditionDao = pullRequestConditionDao;
        this.refMatcherProviderRegistry = refMatcherProviderRegistry;
        this.repositorySupplier = repositorySupplier;
        this.userService = userService;
    }

    @Override
    @Nonnull
    public PullRequestCondition createPullRequestCondition(@Nonnull Scope scope, @Nonnull RefMatcher sourceMatcher, @Nonnull RefMatcher targetMatcher, @Nullable Set<Integer> userIds, @Nullable Set<Long> groupIds, int requiredApprovals) {
        this.checkConditionParameters(scope, sourceMatcher, targetMatcher, userIds, groupIds, requiredApprovals);
        this.validateScopeType(scope);
        this.validateNotPersonalProject(scope);
        this.validateAdminPermission(scope);
        userIds = userIds == null ? Collections.emptySet() : userIds;
        groupIds = groupIds == null ? Collections.emptySet() : groupIds;
        Set users = this.userService.getUsersById(userIds, true);
        this.verifyUsers(userIds, users, scope);
        Set<ReviewerGroup> groups = this.getGroups(groupIds, scope);
        this.verifyGroups(groupIds, groups, scope.getType());
        PullRequestCondition condition = this.toPullRequestCondition(this.pullRequestConditionDao.create(scope, sourceMatcher, targetMatcher, userIds, groupIds, requiredApprovals), users, groups, scope);
        this.eventPublisher.publish((Object)new PullRequestConditionCreatedEvent(this, condition));
        return condition;
    }

    @Override
    @Nonnull
    public Page<PullRequestCondition> getPullRequestConditions(@Nonnull Scope scope, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.validateScopeType(scope);
        this.validateNotPersonalProject(scope);
        this.validateReadPermission(scope);
        return this.pullRequestConditionDao.find(DefaultPullRequestConditionService.getInheritedScopes(scope), pageRequest).transform(aoCondition -> this.toPullRequestCondition((AoPullRequestCondition)aoCondition, scope));
    }

    @Override
    @Nonnull
    public Set<ApplicationUser> getReviewers(@Nonnull Repository repository, @Nonnull Ref sourceRef, @Nonnull Ref targetRef) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(sourceRef, "sourceRef");
        Objects.requireNonNull(targetRef, "targetRef");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
        Set matchingConditions = this.getPullRequestConditions((Scope)Scopes.repository((Repository)repository), PageUtils.newRequest((int)0, (int)100)).stream().filter(condition -> condition.getSourceMatcher().matches((MinimalRef)sourceRef)).filter(condition -> condition.getTargetMatcher().matches((MinimalRef)targetRef)).collect(Collectors.toSet());
        HashSet users = new HashSet();
        matchingConditions.stream().map(PullRequestCondition::getReviewerGroups).flatMap(Collection::stream).map(ReviewerGroup::getUsers).forEach(users::addAll);
        matchingConditions.stream().map(PullRequestCondition::getReviewers).forEach(users::addAll);
        return (Set)users.stream().filter(ApplicationUser::isActive).filter(user -> this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER) && this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_READ)).collect(MoreCollectors.toImmutableSet());
    }

    @EventListener
    public void onProjectDeletionRequested(ProjectDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.pullRequestConditionDao.deleteForScope((Scope)Scopes.project((Project)event.getProject()));
        }
    }

    @EventListener
    public void onRepositoryDeletionRequested(RepositoryDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.pullRequestConditionDao.deleteForScope((Scope)Scopes.repository((Repository)event.getRepository()));
        }
    }

    @Override
    public void removePullRequestCondition(@Nonnull Scope scope, int conditionId) {
        Objects.requireNonNull(scope, "scope");
        this.validateScopeType(scope);
        this.validateNotPersonalProject(scope);
        this.validateAdminPermission(scope);
        AoPullRequestCondition conditionToDelete = this.pullRequestConditionDao.getById(scope, conditionId);
        if (conditionToDelete == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.invalid.id", new Object[]{scope, String.valueOf(conditionId)}));
        }
        PullRequestCondition pullRequestCondition = this.toPullRequestCondition(conditionToDelete, scope);
        this.pullRequestConditionDao.delete(conditionToDelete);
        this.eventPublisher.publish((Object)new PullRequestConditionDeletedEvent(this, pullRequestCondition));
    }

    @Override
    @Nonnull
    public PullRequestCondition updatePullRequestCondition(@Nonnull Scope scope, int conditionId, @Nonnull RefMatcher sourceMatcher, @Nonnull RefMatcher targetMatcher, @Nullable Set<Integer> userIds, @Nullable Set<Long> groupIds, int newRequiredApprovals) {
        Set groups;
        Set users;
        this.checkConditionParameters(scope, sourceMatcher, targetMatcher, userIds, groupIds, newRequiredApprovals);
        this.validateScopeType(scope);
        this.validateNotPersonalProject(scope);
        this.validateAdminPermission(scope);
        AoPullRequestCondition condition = this.pullRequestConditionDao.getById(scope, conditionId);
        if (condition == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.invalid.id", new Object[]{scope, String.valueOf(conditionId)}));
        }
        if (userIds == null) {
            Set currentReviewers = Arrays.stream(condition.getReviewers()).filter(c -> c.getType() == ReviewerType.USER.getId()).map(reviewer -> (int)reviewer.getReviewerId()).collect(Collectors.toSet());
            users = this.userService.getUsersById(currentReviewers, true);
        } else {
            users = this.userService.getUsersById(userIds, true);
            this.verifyUsers(userIds, users, scope);
        }
        if (groupIds == null) {
            Set currentReviewerGroups = Arrays.stream(condition.getReviewers()).filter(c -> c.getType() == ReviewerType.REVIEWER_GROUP.getId()).map(AoReviewer::getReviewerId).collect(Collectors.toSet());
            groups = this.reviewerGroupService.getByIds(currentReviewerGroups, scope);
        } else {
            groups = this.getGroups(groupIds, scope);
            this.verifyGroups(groupIds, groups, scope.getType());
        }
        PullRequestCondition initialCondition = this.toPullRequestCondition(condition, scope);
        PullRequestCondition updatedCondition = this.toPullRequestCondition(this.pullRequestConditionDao.update(condition, sourceMatcher, targetMatcher, userIds, groupIds, newRequiredApprovals), users, groups, scope);
        this.eventPublisher.publish((Object)new PullRequestConditionUpdatedEvent(this, updatedCondition, initialCondition));
        return updatedCondition;
    }

    @Nonnull
    private static Collection<Scope> getInheritedScopes(Scope scope) {
        return (Collection)scope.accept((ScopeVisitor)new ScopeVisitor<ImmutableList<Scope>>(){

            public ImmutableList<Scope> visit(@Nonnull ProjectScope scope) {
                return ImmutableList.of((Object)scope);
            }

            public ImmutableList<Scope> visit(@Nonnull RepositoryScope scope) {
                return ImmutableList.of((Object)scope, (Object)Scopes.project((Project)scope.getProject()));
            }
        });
    }

    private void checkConditionParameters(Scope scope, RefMatcher sourceMatcher, RefMatcher targetMatcher, Set<Integer> userIds, Set<Long> groupIds, int requiredApprovals) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(sourceMatcher, "sourceMatcher");
        Objects.requireNonNull(targetMatcher, "targetMatcher");
        if ("BRANCH".equals(sourceMatcher.getType().getId()) && "BRANCH".equals(targetMatcher.getType().getId()) && sourceMatcher.getId().equals(targetMatcher.getId())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.invalid.ref.branches.equal", new Object[0]));
        }
        if ("PATTERN".equals(sourceMatcher.getType().getId()) && CharMatcher.whitespace().matchesAnyOf((CharSequence)sourceMatcher.getId()) || "PATTERN".equals(targetMatcher.getType().getId()) && CharMatcher.whitespace().matchesAnyOf((CharSequence)targetMatcher.getId())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.invalid.pattern.whitespace", new Object[0]));
        }
        if (requiredApprovals < 0) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.rest.condition.approvals", new Object[0]));
        }
        if (userIds == null && groupIds == null || userIds != null && userIds.isEmpty() && groupIds != null && groupIds.isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.rest.condition.without.reviewers", new Object[0]));
        }
    }

    private Set<ReviewerGroup> getGroups(Set<Long> groupIds, Scope scope) {
        if (groupIds.isEmpty()) {
            return Collections.emptySet();
        }
        return this.reviewerGroupService.getByIds(groupIds, scope);
    }

    private RefMatcher getRefMatcher(Scope scope, String matcherId, String matcherType) {
        RefMatcherProvider provider = this.refMatcherProviderRegistry.getProvider(matcherType);
        if (provider == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.invalid.provider", new Object[]{matcherId}));
        }
        return (RefMatcher)provider.create(scope, matcherId).orElseThrow(() -> new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.cannot.create.provider", new Object[]{matcherId, scope})));
    }

    private Scope getScope(int resourceId, ScopeType scopeType) {
        switch (scopeType) {
            case REPOSITORY: {
                Repository repository = this.repositorySupplier.getById(resourceId);
                if (repository == null) {
                    throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.no.repository", new Object[]{String.valueOf(resourceId)}), null);
                }
                return Scopes.repository((Repository)repository);
            }
            case PROJECT: {
                Project project = this.projectSupplier.getById(resourceId);
                if (project == null) {
                    throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.no.project", new Object[]{String.valueOf(resourceId)}));
                }
                return Scopes.project((Project)project);
            }
        }
        throw new IllegalStateException(String.format("There should be no AoPullRequestConditions with a scope %s", scopeType));
    }

    private PullRequestCondition toPullRequestCondition(AoPullRequestCondition condition, Scope resolutionScope) {
        Set userIds = (Set)Arrays.stream(condition.getReviewers()).filter(r -> r.getType() == ReviewerType.USER.getId()).map(AoReviewer::getReviewerId).mapToInt(Long::intValue).boxed().collect(MoreCollectors.toImmutableSet());
        Set users = this.userService.getUsersById(userIds, true);
        Set groupIds = (Set)Arrays.stream(condition.getReviewers()).filter(r -> r.getType() == ReviewerType.REVIEWER_GROUP.getId()).map(AoReviewer::getReviewerId).collect(MoreCollectors.toImmutableSet());
        Set<ReviewerGroup> groups = this.getGroups(groupIds, resolutionScope);
        Scope conditionScope = this.getScope(condition.getResourceId(), condition.getScopeType());
        return new SimplePullRequestCondition(conditionScope, condition.getId(), this.getRefMatcher(resolutionScope, condition.getSourceMatcherId(), condition.getSourceMatcherType()), this.getRefMatcher(resolutionScope, condition.getTargetMatcherId(), condition.getTargetMatcherType()), users, groups, condition.getRequiredApprovals());
    }

    private PullRequestCondition toPullRequestCondition(AoPullRequestCondition condition, Collection<ApplicationUser> users, Collection<ReviewerGroup> reviewerGroups, Scope resolutionScope) {
        Scope conditionScope = this.getScope(condition.getResourceId(), condition.getScopeType());
        return new SimplePullRequestCondition(conditionScope, condition.getId(), this.getRefMatcher(resolutionScope, condition.getSourceMatcherId(), condition.getSourceMatcherType()), this.getRefMatcher(resolutionScope, condition.getTargetMatcherId(), condition.getTargetMatcherType()), users, reviewerGroups, condition.getRequiredApprovals());
    }

    private void validateAdminPermission(Scope scope) {
        scope.accept((ScopeVisitor)new AbstractDefaultReviewersScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultPullRequestConditionService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultPullRequestConditionService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateNotPersonalProject(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                if (scope.getProject().getType() == ProjectType.PERSONAL) {
                    throw new ArgumentValidationException(DefaultPullRequestConditionService.this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.personalproject", new Object[0]));
                }
                return null;
            }
        });
    }

    private void validateReadPermission(Scope scope) {
        scope.accept((ScopeVisitor)new AbstractDefaultReviewersScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultPullRequestConditionService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_READ);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultPullRequestConditionService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_READ);
                return null;
            }
        });
    }

    private void validateScopeType(Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() != ScopeType.PROJECT && scope.getType() != ScopeType.REPOSITORY) {
            throw new IllegalArgumentException(String.format("The branch model can not be configured at a %s level scope.", scope.getType()));
        }
    }

    private void verifyGroups(Set<Long> groupIds, Set<ReviewerGroup> foundGroups, ScopeType scopeType) {
        Set foundGroupIds;
        Optional missingId;
        if (foundGroups.size() != groupIds.size() && (missingId = Sets.difference(groupIds, (Set)(foundGroupIds = (Set)foundGroups.stream().map(ReviewerGroup::getId).collect(MoreCollectors.toImmutableSet()))).stream().findFirst()).isPresent()) {
            try {
                ReviewerGroup missingGroup = this.reviewerGroupService.getById(((Long)missingId.get()).longValue());
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.no.reviewer.group.access", new Object[]{missingGroup.getName(), scopeType.toString().toLowerCase(Locale.ROOT)}));
            }
            catch (NoSuchReviewerGroupException e) {
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.no.reviewer.group", new Object[]{String.valueOf(missingId.get())}));
            }
        }
    }

    private void verifyUsers(@Nonnull Set<Integer> userIds, final @Nonnull Set<ApplicationUser> users, @Nonnull Scope scope) {
        Optional missingId;
        Set foundUserIds = (Set)users.stream().filter(u -> u.getType() != UserType.SERVICE).map(ApplicationUser::getId).collect(MoreCollectors.toImmutableSet());
        if (userIds.size() != foundUserIds.size() && (missingId = Sets.difference(userIds, (Set)foundUserIds).stream().findFirst()).isPresent()) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.no.user", new Object[]{String.valueOf(missingId.get())}));
        }
        scope.accept((ScopeVisitor)new AbstractDefaultReviewersScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                users.stream().filter(user -> !DefaultPullRequestConditionService.this.permissionService.hasProjectPermission(user, projectScope.getProject(), Permission.PROJECT_READ)).findFirst().ifPresent(unauthorizedUser -> {
                    throw new NoSuchEntityException(DefaultPullRequestConditionService.this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.no.user.access", new Object[]{unauthorizedUser.getName(), ScopeType.PROJECT.toString().toLowerCase(Locale.ROOT)}));
                });
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                users.stream().filter(user -> !DefaultPullRequestConditionService.this.permissionService.hasRepositoryPermission(user, repositoryScope.getRepository(), Permission.REPO_READ)).findFirst().ifPresent(unauthorizedUser -> {
                    throw new NoSuchEntityException(DefaultPullRequestConditionService.this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.no.user.access", new Object[]{unauthorizedUser.getName(), ScopeType.REPOSITORY.toString().toLowerCase(Locale.ROOT)}));
                });
                return null;
            }
        });
    }
}

