/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.internal.defaultreviewers.AbstractDefaultReviewersScopeVisitor;
import com.atlassian.bitbucket.internal.defaultreviewers.PullRequestConditionService;
import com.atlassian.bitbucket.internal.defaultreviewers.model.PullRequestCondition;
import com.atlassian.bitbucket.internal.defaultreviewers.rest.RestPullRequestCondition;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@LicensedOnly
public class ReviewerSettingsServlet
extends HttpServlet {
    private static final int MAX_PAGE_SIZE = 100;
    private static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-default-reviewers:default-reviewers-page-templates";
    private static final String SETTINGS_PAGE_CONTEXT = "bitbucket.page.default.reviewers.settings";
    private static final String TEMPLATE_KEY = "bitbucketPluginDefaultReviewers.internal.page.defaultReviewers.defaultReviewersPage.defaultReviewersSettings";
    private final AvatarEnricher avatarEnricher;
    private final NavBuilder navBuilder;
    private final PageBuilderService pageBuilderService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestConditionService pullRequestConditionService;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final ProjectService projectService;

    public ReviewerSettingsServlet(AvatarEnricher avatarEnricher, NavBuilder navBuilder, PermissionService permissionService, PermissionValidationService permissionValidationService, PullRequestConditionService pullRequestConditionService, PageBuilderService pageBuilderService, RefService refService, RepositoryService repositoryService, SoyTemplateRenderer soyTemplateRenderer, ProjectService projectService) {
        this.avatarEnricher = avatarEnricher;
        this.navBuilder = navBuilder;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.pullRequestConditionService = pullRequestConditionService;
        this.pageBuilderService = pageBuilderService;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.projectService = projectService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.renderDefaultReviewerView(req, resp);
    }

    private static int compare(PullRequestCondition o1, PullRequestCondition o2) {
        return ComparisonChain.start().compare((Comparable)((Object)o1.getSourceMatcher().getDisplayId()), (Comparable)((Object)o2.getSourceMatcher().getDisplayId())).compare((Comparable)((Object)o1.getTargetMatcher().getDisplayId()), (Comparable)((Object)o2.getTargetMatcher().getDisplayId())).compare(o1.getId(), o2.getId()).result();
    }

    private Map<String, Object> createViewContext(Scope scope, Collection<PullRequestCondition> pullRequestConditions, boolean secure) {
        final ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        contextBuilder.put((Object)"pullRequestConditions", this.restify(pullRequestConditions, secure));
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                contextBuilder.put((Object)"project", (Object)scope.getProject());
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                Project project = scope.getProject();
                contextBuilder.put((Object)"project", (Object)project);
                contextBuilder.put((Object)"repository", (Object)scope.getRepository());
                if (ReviewerSettingsServlet.this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
                    contextBuilder.put((Object)"projectSettingsUrl", (Object)ReviewerSettingsServlet.this.navBuilder.pluginServlets().path(new String[]{"default-reviewers", "projects", project.getKey()}).buildRelative());
                }
                try {
                    contextBuilder.put((Object)"defaultBranch", (Object)ReviewerSettingsServlet.this.refService.getDefaultBranch(scope.getRepository()).getId());
                }
                catch (NoDefaultBranchException | RepositoryOfflineException throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        contextBuilder.put((Object)"scopeType", (Object)scope.getType());
        return contextBuilder.build();
    }

    private Optional<Scope> getScope(String pathInfo) {
        if (Strings.isNullOrEmpty((String)pathInfo)) {
            return Optional.empty();
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        switch (pathParts.length) {
            case 2: {
                return Optional.ofNullable(this.projectService.getByKey(pathParts[1])).map(Scopes::project);
            }
            case 4: {
                return Optional.ofNullable(this.repositoryService.getBySlug(pathParts[1], pathParts[3])).map(Scopes::repository);
            }
        }
        return Optional.empty();
    }

    private void handleSoyError(SoyException e) throws IOException, ServletException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new ServletException((Throwable)e);
    }

    private void prepareResponse(HttpServletResponse response) {
        this.pageBuilderService.assembler().resources().requireContext(SETTINGS_PAGE_CONTEXT);
        response.setContentType("text/html;charset=UTF-8");
    }

    private void render(HttpServletResponse response, Map<String, Object> context) throws ServletException, IOException {
        this.prepareResponse(response);
        try {
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, context);
        }
        catch (SoyException soyException) {
            this.handleSoyError(soyException);
        }
    }

    private void renderDefaultReviewerView(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List pullRequestConditions;
        String pathInfo = req.getPathInfo();
        Optional<Scope> opScope = this.getScope(pathInfo);
        if (!opScope.isPresent()) {
            resp.sendError(404);
            return;
        }
        Scope scope = opScope.get();
        this.validateAdminPermissions(scope);
        try {
            pullRequestConditions = (List)this.pullRequestConditionService.getPullRequestConditions(scope, PageUtils.newRequest((int)0, (int)100)).stream().sorted(ReviewerSettingsServlet::compare).collect(MoreCollectors.toImmutableList());
        }
        catch (ArgumentValidationException e) {
            resp.sendError(400, e.getLocalizedMessage());
            return;
        }
        this.render(resp, this.createViewContext(scope, pullRequestConditions, req.isSecure()));
    }

    private Iterable<RestPullRequestCondition> restify(Collection<PullRequestCondition> conditions, boolean secure) {
        return (Iterable)conditions.stream().map(condition -> {
            RestPullRequestCondition restCondition = new RestPullRequestCondition((PullRequestCondition)condition);
            restCondition.getReviewerGroups().forEach(reviewerGroup -> this.avatarEnricher.enrich(reviewerGroup, new AvatarRequest(secure, 32)));
            restCondition.getReviewers().forEach(reviewer -> this.avatarEnricher.enrich(reviewer, new AvatarRequest(secure, 32)));
            return restCondition;
        }).collect(MoreCollectors.toImmutableList());
    }

    private void validateAdminPermissions(Scope scope) {
        scope.accept((ScopeVisitor)new AbstractDefaultReviewersScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                ReviewerSettingsServlet.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                ReviewerSettingsServlet.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }
}

