/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.audit;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.internal.defaultreviewers.event.PullRequestConditionCreatedEvent;
import com.atlassian.bitbucket.internal.defaultreviewers.event.PullRequestConditionEvent;
import com.atlassian.bitbucket.internal.defaultreviewers.event.PullRequestConditionUpdatedEvent;
import com.atlassian.bitbucket.internal.defaultreviewers.model.PullRequestCondition;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.stream.Collectors;

public class PullRequestConditionEventConverter
implements AuditEventConverter<PullRequestConditionEvent> {
    @VisibleForTesting
    static final String ACTION_REPOSITORY_CREATED_EVENT = "bitbucket.defaultreviewers.audit.action.repositorypullrequestconditioncreated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_DELETED_EVENT = "bitbucket.defaultreviewers.audit.action.repositorypullrequestconditiondeleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_UPDATED_EVENT = "bitbucket.defaultreviewers.audit.action.repositorypullrequestconditionupdated";
    @VisibleForTesting
    static final String ATTR_ID = "bitbucket.defaultreviewers.audit.attribute.pullrequestconditionevent.id";
    @VisibleForTesting
    static final String ATTR_SOURCE_MATCHER = "bitbucket.defaultreviewers.audit.attribute.pullrequestconditionevent.sourcematcher";
    @VisibleForTesting
    static final String ATTR_SOURCE_MATCHER_TYPE = "bitbucket.defaultreviewers.audit.attribute.pullrequestconditionevent.sourcematchertype";
    @VisibleForTesting
    static final String ATTR_TARGET_MATCHER = "bitbucket.defaultreviewers.audit.attribute.pullrequestconditionevent.targetmatcher";
    @VisibleForTesting
    static final String ATTR_TARGET_MATCHER_TYPE = "bitbucket.defaultreviewers.audit.attribute.pullrequestconditionevent.targetmatchertype";
    @VisibleForTesting
    static final String ATTR_REQUIRED_APPROVALS = "bitbucket.defaultreviewers.audit.attribute.pullrequestconditionevent.requiredapprovals";
    @VisibleForTesting
    static final String ATTR_REVIEWER_GROUPS = "bitbucket.defaultreviewers.audit.attribute.pullrequestconditionevent.reviewergroups";
    @VisibleForTesting
    static final String ATTR_REVIEWERS = "bitbucket.defaultreviewers.audit.attribute.pullrequestconditionevent.reviewers";

    @Nonnull
    public AuditEvent convert(final @Nonnull PullRequestConditionEvent event, final @Nonnull AuditEvent.Builder builder) {
        PullRequestCondition pullRequestCondition = event.getPullRequestCondition();
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ID, (String)String.valueOf(pullRequestCondition.getId())).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SOURCE_MATCHER, (String)pullRequestCondition.getSourceMatcher().getDisplayId()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SOURCE_MATCHER_TYPE, (String)pullRequestCondition.getSourceMatcher().getType().getDisplayId()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TARGET_MATCHER, (String)pullRequestCondition.getTargetMatcher().getDisplayId()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TARGET_MATCHER_TYPE, (String)pullRequestCondition.getTargetMatcher().getType().getDisplayId()).build());
        event.getScope().accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                builder.affectedObject(AuditUtils.auditResourceForProject((Project)scope.getProject()));
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                builder.actionI18nKey(PullRequestConditionEventConverter.toRepositoryActionI18nKey(event)).categoryI18nKey("bitbucket.service.audit.category.repositories").affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)scope.getRepository()));
                return null;
            }
        });
        if (event instanceof PullRequestConditionUpdatedEvent) {
            return PullRequestConditionEventConverter.addChangedValues(pullRequestCondition, ((PullRequestConditionUpdatedEvent)event).getOldPullRequestCondition(), builder).build();
        }
        return PullRequestConditionEventConverter.addExtraAttributes(pullRequestCondition, builder).build();
    }

    private static AuditEvent.Builder addChangedValues(PullRequestCondition newPullRequestCondition, PullRequestCondition oldPullRequestCondition, AuditEvent.Builder builder) {
        return builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_REQUIRED_APPROVALS).from(String.valueOf(oldPullRequestCondition.getRequiredApprovals())).to(String.valueOf(newPullRequestCondition.getRequiredApprovals())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_REVIEWERS).from(PullRequestConditionEventConverter.reviewersToString(oldPullRequestCondition.getReviewers())).to(PullRequestConditionEventConverter.reviewersToString(newPullRequestCondition.getReviewers())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_REVIEWER_GROUPS).from(PullRequestConditionEventConverter.reviewerGroupsToString(oldPullRequestCondition.getReviewerGroups())).to(PullRequestConditionEventConverter.reviewerGroupsToString(newPullRequestCondition.getReviewerGroups())).build());
    }

    private static AuditEvent.Builder addExtraAttributes(PullRequestCondition condition, AuditEvent.Builder builder) {
        return builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_REQUIRED_APPROVALS, (String)String.valueOf(condition.getRequiredApprovals())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_REVIEWERS, (String)PullRequestConditionEventConverter.reviewersToString(condition.getReviewers())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_REVIEWER_GROUPS, (String)PullRequestConditionEventConverter.reviewerGroupsToString(condition.getReviewerGroups())).build());
    }

    private static String reviewerGroupsToString(Collection<ReviewerGroup> reviewerGroups) {
        if (reviewerGroups.isEmpty()) {
            return null;
        }
        return reviewerGroups.stream().map(ReviewerGroup::getName).collect(Collectors.joining(", "));
    }

    private static String reviewersToString(Collection<ApplicationUser> reviewers) {
        if (reviewers.isEmpty()) {
            return null;
        }
        return reviewers.stream().map(ApplicationUser::getSlug).collect(Collectors.joining(", "));
    }

    private static String toRepositoryActionI18nKey(PullRequestConditionEvent event) {
        if (event instanceof PullRequestConditionCreatedEvent) {
            return ACTION_REPOSITORY_CREATED_EVENT;
        }
        if (event instanceof PullRequestConditionUpdatedEvent) {
            return ACTION_REPOSITORY_UPDATED_EVENT;
        }
        return ACTION_REPOSITORY_DELETED_EVENT;
    }
}

