/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.AoPullRequestCondition;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.AoReviewer;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.PullRequestConditionDao;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.ReviewerType;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;

public class AoPullRequestConditionDao
extends AbstractAoDao
implements PullRequestConditionDao {
    public AoPullRequestConditionDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public AoPullRequestCondition create(@Nonnull Scope scope, @Nonnull RefMatcher sourceMatcher, @Nonnull RefMatcher targetMatcher, @Nonnull Set<Integer> userIds, @Nonnull Set<Long> reviewerGroupIds, int requiredApprovals) {
        Integer resourceId = (Integer)scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Pull request condition cannot be created at scope type: " + String.valueOf(scope.getType())));
        AoPullRequestCondition refCondition = this.createRefCondition(resourceId, scope.getType(), sourceMatcher, targetMatcher, requiredApprovals);
        userIds.forEach(id -> this.createReviewer(refCondition, ReviewerType.USER, id.intValue()));
        reviewerGroupIds.forEach(id -> this.createReviewer(refCondition, ReviewerType.REVIEWER_GROUP, (long)id));
        return (AoPullRequestCondition)this.ao.get(AoPullRequestCondition.class, (Object)refCondition.getId());
    }

    @Override
    public void delete(@Nonnull AoPullRequestCondition condition) {
        this.ao.delete((RawEntity[])condition.getReviewers());
        this.ao.delete(new RawEntity[]{condition});
    }

    @Override
    public void deleteForScope(@Nonnull Scope scope) {
        Integer resourceId = (Integer)scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Pull request condition cannot be deleted at scope type: " + String.valueOf(scope.getType())));
        Arrays.stream((AoPullRequestCondition[])this.ao.find(AoPullRequestCondition.class, Query.select().where("RESOURCE_ID= ? AND SCOPE_TYPE= ? ", new Object[]{resourceId, scope.getType()}))).forEach(this::delete);
    }

    @Override
    @Nonnull
    public Page<AoPullRequestCondition> find(@Nonnull Collection<Scope> scopes, @Nonnull PageRequest pageRequest) {
        ArrayList whereArguments = Lists.newArrayList();
        ArrayList whereClauses = Lists.newArrayList();
        scopes.forEach(scope -> {
            whereClauses.add("(RESOURCE_ID= ? AND SCOPE_TYPE= ? )");
            whereArguments.add(scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Pull request condition cannot be searched at scope type: " + String.valueOf(scope.getType()))));
            whereArguments.add(scope.getType());
        });
        String whereClause = StringUtils.join((Iterable)whereClauses, (String)" OR ");
        Query query = AoUtils.newQuery((String[])new String[]{"PR_CONDITION_ID", "RESOURCE_ID", "SOURCE_REF_VALUE", "SOURCE_REF_TYPE", "TARGET_REF_VALUE", "TARGET_REF_TYPE"}).where(whereClause, whereArguments.toArray()).order("SOURCE_REF_TYPE, SOURCE_REF_VALUE, TARGET_REF_TYPE, TARGET_REF_VALUE ASC");
        return this.pageQuery(AoPullRequestCondition.class, query, pageRequest);
    }

    @Override
    @Nullable
    public AoPullRequestCondition getById(@Nonnull Scope scope, int conditionId) {
        Integer resourceId = (Integer)scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Pull request condition cannot be managed at scope type: " + String.valueOf(scope.getType())));
        AoPullRequestCondition condition = (AoPullRequestCondition)this.ao.get(AoPullRequestCondition.class, (Object)conditionId);
        if (condition == null || !condition.getResourceId().equals(resourceId) && scope.getType().equals((Object)condition.getScopeType())) {
            return null;
        }
        return condition;
    }

    @Override
    @Nonnull
    public AoPullRequestCondition update(@Nonnull AoPullRequestCondition condition, @Nullable RefMatcher sourceMatcher, @Nullable RefMatcher targetMatcher, @Nullable Set<Integer> userIds, @Nullable Set<Long> reviewerGroupIds, int requiredApprovals) {
        if (sourceMatcher != null) {
            condition.setSourceMatcherId(sourceMatcher.getId());
            condition.setSourceMatcherType(sourceMatcher.getType().getId());
        }
        if (targetMatcher != null) {
            condition.setTargetMatcherId(targetMatcher.getId());
            condition.setTargetMatcherType(targetMatcher.getType().getId());
        }
        if (userIds != null) {
            Set currentUsers = Arrays.stream(condition.getReviewers()).filter(r -> r.getType() == ReviewerType.USER.getId()).collect(Collectors.toSet());
            this.ao.delete((RawEntity[])currentUsers.toArray(AoReviewer[]::new));
            userIds.forEach(id -> this.createReviewer(condition, ReviewerType.USER, id.intValue()));
        }
        if (reviewerGroupIds != null) {
            Set currentReviewerGroups = Arrays.stream(condition.getReviewers()).filter(r -> r.getType() == ReviewerType.REVIEWER_GROUP.getId()).collect(Collectors.toSet());
            this.ao.delete((RawEntity[])currentReviewerGroups.toArray(AoReviewer[]::new));
            reviewerGroupIds.forEach(id -> this.createReviewer(condition, ReviewerType.REVIEWER_GROUP, (long)id));
        }
        condition.setRequiredApprovals(requiredApprovals);
        condition.save();
        return (AoPullRequestCondition)this.ao.get(AoPullRequestCondition.class, (Object)condition.getId());
    }

    private AoPullRequestCondition createRefCondition(Integer resourceId, ScopeType scopeType, RefMatcher sourceMatcher, RefMatcher targetMatcher, int requiredApprovals) {
        return (AoPullRequestCondition)this.ao.create(AoPullRequestCondition.class, (Map)ImmutableMap.builder().put((Object)"RESOURCE_ID", (Object)resourceId).put((Object)"SCOPE_TYPE", (Object)scopeType).put((Object)"SOURCE_REF_VALUE", (Object)sourceMatcher.getId()).put((Object)"SOURCE_REF_TYPE", (Object)sourceMatcher.getType().getId()).put((Object)"TARGET_REF_VALUE", (Object)targetMatcher.getId()).put((Object)"TARGET_REF_TYPE", (Object)targetMatcher.getType().getId()).put((Object)"REQUIRED_APPROVALS", (Object)requiredApprovals).build());
    }

    private AoReviewer createReviewer(AoPullRequestCondition refCondition, ReviewerType type, long id) {
        AoReviewer aoReviewer = (AoReviewer)this.ao.create(AoReviewer.class, (Map)ImmutableMap.builder().put((Object)"FK_RESTRICTED_ID", (Object)refCondition.getId()).put((Object)"TYPE", (Object)type.getId()).put((Object)"REVIEWER_ID", (Object)id).build());
        aoReviewer.setCondition(refCondition);
        aoReviewer.save();
        return aoReviewer;
    }
}

