/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.dao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.v0.AoPullRequestConditionV0;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.v1.AoPullRequestConditionV1;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.v1.AoReviewerV1;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToV1Task
implements ActiveObjectsUpgradeTask {
    private static final int DEFAULT_PAGE_SIZE = 250;
    private static final Logger log = LoggerFactory.getLogger(MigrateToV1Task.class);
    private final int pageSize;

    public MigrateToV1Task(int pageSize) {
        this.pageSize = pageSize;
    }

    public MigrateToV1Task() {
        this(250);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects ao) {
        log.debug("Attempting default reviewers data upgrade on model version {}", (Object)modelVersion.toString());
        Preconditions.checkState((boolean)modelVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This task can only upgrade from version 0 to 1");
        log.info("Starting to migrate default reviewers model data");
        ao.migrate(new Class[]{AoPullRequestMigrationModel.class});
        PagedIterable conditions = new PagedIterable(request -> PageUtils.createPage(Arrays.asList((AoPullRequestMigrationModel[])ao.find(AoPullRequestMigrationModel.class, AoUtils.restrict((Query)Query.select().order("PR_CONDITION_ID"), (PageRequest)request))), (PageRequest)request), this.pageSize);
        for (AoPullRequestMigrationModel condition : conditions) {
            log.trace("Attempting to migrate rule with id {}", (Object)condition.getId());
            this.migrate(condition);
            log.trace("Migrated rule successfully");
        }
        ao.migrateDestructively(new Class[]{AoPullRequestConditionV1.class, AoReviewerV1.class});
        log.info("Migration of default reviewers model data is complete");
    }

    private void migrate(AoPullRequestMigrationModel condition) {
        condition.setResourceId(condition.getRepositoryId());
        condition.setScopeType(ScopeType.REPOSITORY);
        condition.save();
    }

    @Table(value="PR_CONDITION")
    @Preload
    static interface AoPullRequestMigrationModel
    extends AoPullRequestConditionV0 {
        @Accessor(value="RESOURCE_ID")
        public Integer getResourceId();

        @Mutator(value="RESOURCE_ID")
        public void setResourceId(Integer var1);

        @Accessor(value="SCOPE_TYPE")
        public ScopeType getScopeType();

        @Mutator(value="SCOPE_TYPE")
        public void setScopeType(ScopeType var1);
    }
}

