/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.dao.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.AoPullRequestCondition;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.AoReviewer;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.ReviewerType;
import com.atlassian.bitbucket.internal.defaultreviewers.dao.v1.AoReviewerV1;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToV2Task
implements ActiveObjectsUpgradeTask {
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private static final Logger log = LoggerFactory.getLogger(MigrateToV2Task.class);
    private final int pageSize;

    public MigrateToV2Task(int pageSize) {
        this.pageSize = pageSize;
    }

    public MigrateToV2Task() {
        this(1000);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)modelVersion.isSame(ModelVersion.valueOf((String)"1")), (Object)("This task can only upgrade from version 1 to version 2.  Current model version: " + String.valueOf(modelVersion)));
        log.info("Migrating default reviewers model data from version 1 to version 2");
        ao.deleteWithSQL(AoReviewerV1.class, "USER_ID IS NULL", new Object[0]);
        ao.migrate(new Class[]{AoReviewerV1ToV2MigrationModel.class});
        PagedIterable reviewers = new PagedIterable(request -> PageUtils.createPage(Arrays.asList((AoReviewerV1ToV2MigrationModel[])ao.find(AoReviewerV1ToV2MigrationModel.class, AoUtils.restrict((Query)Query.select().order("ENTITY_ID"), (PageRequest)request))), (PageRequest)request), this.pageSize);
        for (AoReviewerV1ToV2MigrationModel reviewer : reviewers) {
            log.trace("Migrating default reviewer with id {}", (Object)reviewer.getId());
            reviewer.setReviewerId(reviewer.getUserId().intValue());
            reviewer.setType(ReviewerType.USER.getId());
            reviewer.save();
        }
        ao.migrateDestructively(new Class[]{AoPullRequestCondition.class, AoReviewer.class});
        log.info("Migration of default reviewers model data is complete");
    }

    @Table(value="DEFAULT_REVIEWER")
    @Preload
    static interface AoReviewerV1ToV2MigrationModel
    extends AoReviewerV1 {
        @Accessor(value="REVIEWER_ID")
        public long getReviewerId();

        @Accessor(value="TYPE")
        public int getType();

        @Mutator(value="REVIEWER_ID")
        public void setReviewerId(long var1);

        @Mutator(value="TYPE")
        public void setType(int var1);
    }
}

