/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.mergecheck;

import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.defaultreviewers.PullRequestConditionService;
import com.atlassian.bitbucket.internal.defaultreviewers.model.PullRequestCondition;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RequiredReviewersMergeCheck
implements RepositoryMergeCheck {
    private static final int MAX_PAGE_SIZE = 100;
    private final I18nService i18nService;
    private final PullRequestConditionService pullRequestConditionService;

    public RequiredReviewersMergeCheck(I18nService i18nService, PullRequestConditionService pullRequestConditionService) {
        this.i18nService = i18nService;
        this.pullRequestConditionService = pullRequestConditionService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        Objects.requireNonNull(request, "request");
        PullRequest pullRequest = request.getPullRequest();
        PullRequestRef sourceRef = pullRequest.getFromRef();
        PullRequestRef targetRef = pullRequest.getToRef();
        RepositoryScope scope = Scopes.repository((Repository)targetRef.getRepository());
        PagedIterable pullRequestConditions = new PagedIterable(arg_0 -> this.lambda$preUpdate$0((Scope)scope, arg_0), 100);
        Set approvers = pullRequest.getReviewers().stream().filter(PullRequestParticipant::isApproved).map(PullRequestParticipant::getUser).collect(Collectors.toSet());
        HashMap alreadyVetoed = new HashMap();
        RepositoryHookResult.Builder resultBuilder = new RepositoryHookResult.Builder();
        MoreStreams.streamIterable((Iterable)pullRequestConditions).filter(pullRequestCondition -> pullRequestCondition.getRequiredApprovals() > 0).filter(pullRequestCondition -> pullRequestCondition.getSourceMatcher().matches((MinimalRef)sourceRef)).filter(pullRequestCondition -> pullRequestCondition.getTargetMatcher().matches((MinimalRef)targetRef)).distinct().sorted((a, b) -> b.getRequiredApprovals() - a.getRequiredApprovals()).map(pullRequestCondition -> this.vetoReason(pullRequest, (PullRequestCondition)pullRequestCondition, approvers, alreadyVetoed)).filter(Optional::isPresent).map(Optional::get).forEach(reason -> resultBuilder.veto(this.i18nService.getMessage("bitbucket.defaultreviewers.requiredreviewers.mergecheck.vetoed.summary", new Object[0]), reason));
        return resultBuilder.build();
    }

    private Optional<String> joinNames(List<String> names) {
        if (names == null || names.isEmpty()) {
            return Optional.empty();
        }
        if (names.size() == 1) {
            return Optional.of(names.get(0));
        }
        return names.stream().reduce((a, b) -> String.format("%s%s %s", a, this.i18nService.getMessage("bitbucket.defaultreviewers.requiredreviewers.mergecheck.vetoed.joiner", new Object[0]), b));
    }

    private Optional<String> joinNames(List<String> names, String finalJoiner) {
        if (names == null || names.isEmpty()) {
            return Optional.empty();
        }
        if (names.size() == 1) {
            return Optional.of(names.get(0));
        }
        return this.joinNames(names.subList(0, names.size() - 1)).map(reasonStart -> String.format("%s %s %s", reasonStart, finalJoiner, names.get(names.size() - 1)));
    }

    private Optional<String> vetoReason(PullRequest pullRequest, PullRequestCondition pullRequestCondition, Set<ApplicationUser> approvers, Map<Set<ApplicationUser>, Integer> alreadyVetoed) {
        HashSet<ApplicationUser> requiredApprovers = new HashSet<ApplicationUser>(pullRequestCondition.getReviewers());
        requiredApprovers.addAll((Collection)pullRequestCondition.getReviewerGroups().stream().flatMap(group -> group.getUsers().stream()).collect(MoreCollectors.toImmutableSet()));
        requiredApprovers.remove(pullRequest.getAuthor().getUser());
        int requiredApprovals = Math.min(pullRequestCondition.getRequiredApprovals(), requiredApprovers.size());
        if (alreadyVetoed.containsKey(requiredApprovers) && alreadyVetoed.get(requiredApprovers) >= requiredApprovals) {
            return Optional.empty();
        }
        int alreadyApproved = Sets.intersection(requiredApprovers, approvers).size();
        if (requiredApprovals > alreadyApproved) {
            alreadyVetoed.put(requiredApprovers, requiredApprovals);
            List<String> approverNames = requiredApprovers.stream().map(ApplicationUser::getDisplayName).collect(Collectors.toList());
            if (approverNames.size() == 1 || approverNames.size() == requiredApprovals) {
                return this.joinNames(approverNames, this.i18nService.getMessage("bitbucket.defaultreviewers.requiredreviewers.mergecheck.vetoed.joinerAnd", new Object[0])).map(namesComponent -> this.i18nService.getMessage("bitbucket.defaultreviewers.requiredreviewers.mergecheck.vetoed.description", new Object[]{namesComponent}));
            }
            if (requiredApprovals == 1) {
                return this.joinNames(approverNames, this.i18nService.getMessage("bitbucket.defaultreviewers.requiredreviewers.mergecheck.vetoed.joinerOr", new Object[0])).map(namesComponent -> this.i18nService.getMessage("bitbucket.defaultreviewers.requiredreviewers.mergecheck.vetoed.description", new Object[]{namesComponent}));
            }
            return this.joinNames(approverNames).map(namesComponent -> this.i18nService.getMessage("bitbucket.defaultreviewers.requiredreviewers.mergecheck.vetoed.general.description", new Object[]{requiredApprovals, namesComponent}));
        }
        return Optional.empty();
    }

    private /* synthetic */ Page lambda$preUpdate$0(Scope scope, PageRequest pageRequest) {
        return PageUtils.asPageOf(PullRequestCondition.class, this.pullRequestConditionService.getPullRequestConditions(scope, pageRequest));
    }
}

