/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.model;

import com.atlassian.bitbucket.internal.defaultreviewers.model.PullRequestCondition;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;

public class SimplePullRequestCondition
implements PullRequestCondition {
    private final int id;
    private final int requiredApprovals;
    private final Collection<ApplicationUser> users;
    private final Collection<ReviewerGroup> groups;
    private final Scope scope;
    private final RefMatcher sourceMatcher;
    private final RefMatcher targetMatcher;

    public SimplePullRequestCondition(Scope scope, int id, RefMatcher sourceMatcher, RefMatcher targetMatcher, Collection<ApplicationUser> users, Collection<ReviewerGroup> groups, int requiredApprovals) {
        this.id = id;
        this.scope = Objects.requireNonNull(scope);
        this.requiredApprovals = requiredApprovals;
        this.users = Objects.requireNonNull(users);
        this.groups = Objects.requireNonNull(groups);
        this.sourceMatcher = Objects.requireNonNull(sourceMatcher);
        this.targetMatcher = Objects.requireNonNull(targetMatcher);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PullRequestCondition)) {
            return false;
        }
        PullRequestCondition that = (PullRequestCondition)other;
        return this.id == that.getId() && this.scope.equals((Object)that.getScope()) && this.sourceMatcher.equals((Object)that.getSourceMatcher()) && this.targetMatcher.equals((Object)that.getTargetMatcher()) && this.requiredApprovals == that.getRequiredApprovals() && this.users.equals(that.getReviewers()) && this.groups.equals(that.getReviewerGroups());
    }

    @Override
    @Nonnull
    public RefMatcher getSourceMatcher() {
        return this.sourceMatcher;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getRequiredApprovals() {
        return this.requiredApprovals;
    }

    @Override
    @Nonnull
    public Collection<ApplicationUser> getReviewers() {
        return this.users;
    }

    @Override
    @Nonnull
    public Collection<ReviewerGroup> getReviewerGroups() {
        return this.groups;
    }

    @Override
    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @Nonnull
    public RefMatcher getTargetMatcher() {
        return this.targetMatcher;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.scope, this.sourceMatcher, this.targetMatcher, this.users, this.groups, this.requiredApprovals);
    }
}

