/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.defaultreviewers.rest.DefaultReviewersResourceHelper;
import com.atlassian.bitbucket.internal.defaultreviewers.rest.RestDefaultReviewersRequest;
import com.atlassian.bitbucket.internal.defaultreviewers.rest.RestPullRequestCondition;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key.")})
@Tag(name="Pull Requests")
@LicensedOnly
@Path(value="projects/{projectKey}")
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DefaultReviewersProjectResource {
    private final DefaultReviewersResourceHelper defaultReviewersResourceHelper;

    @Inject
    public DefaultReviewersProjectResource(DefaultReviewersResourceHelper defaultReviewersResourceHelper) {
        this.defaultReviewersResourceHelper = defaultReviewersResourceHelper;
    }

    @Operation(description="Create a default reviewer pull request condition for the given project.", summary="Create default reviewer condition")
    @ResponseDocs(value={@ResponseDoc(documentation="The default reviewer pull request condition that was created.", representation=RestPullRequestCondition.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true)})
    @RequestBody(description="The details needed to create a default reviewer pull request condition.", content={@Content(schema=@Schema(implementation=RestDefaultReviewersRequest.class))})
    @POST
    @Path(value="condition")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createPullRequestCondition(@BeanParam ScopeResolver scopeResolver, RestDefaultReviewersRequest request) {
        return this.defaultReviewersResourceHelper.createPullRequestCondition(scopeResolver.getScope(), request);
    }

    @Operation(description="Delete the default reviewer pull request condition associated with the given ID.", summary="Delete default reviewer condition")
    @Parameter(name="id", description="The ID of the pull request condition.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating that the pull request condition was deleted.", responseCode=204), @ResponseDoc(documentation="An empty response indicating a pull request condition with the given ID could not be found.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="condition/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deletePullRequestCondition(@BeanParam ScopeResolver scopeResolver, @PathParam(value="id") int id) {
        return this.defaultReviewersResourceHelper.deletePullRequestCondition(scopeResolver.getScope(), id);
    }

    @Operation(description="Return a page of default reviewer pull request conditions that have been configured for this project.", summary="Get default reviewer conditions")
    @ApiResponse(description="The default reviewer pull request conditions associated with the given project.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestPullRequestCondition.class)))}, responseCode="200")
    @GET
    @Path(value="conditions")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequestConditions(@BeanParam ScopeResolver scopeResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        return this.defaultReviewersResourceHelper.getPullRequestConditions(scopeResolver.getScope(), pageRequestResolver.getPageRequest());
    }

    @Operation(description="Update the default reviewer pull request condition for the given ID.", summary="Update default reviewer condition")
    @Parameter(name="id", description="The ID of the pull request condition.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The updated default reviewer pull request condition.", representation=RestPullRequestCondition.class, responseCode=200), @ResponseDoc(documentation="The request was malformed", responseCode=400, restError=true)})
    @RequestBody(description="The new details for the default reviewer pull request condition.", content={@Content(schema=@Schema(implementation=RestDefaultReviewersRequest.class))})
    @PUT
    @Path(value="condition/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updatePullRequestCondition(@BeanParam ScopeResolver scopeResolver, @PathParam(value="id") int id, RestDefaultReviewersRequest request) {
        return this.defaultReviewersResourceHelper.updatePullRequestCondition(scopeResolver.getScope(), id, request);
    }
}

