/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.defaultreviewers.PullRequestConditionService;
import com.atlassian.bitbucket.internal.defaultreviewers.rest.DefaultReviewersResourceHelper;
import com.atlassian.bitbucket.internal.defaultreviewers.rest.RestDefaultReviewersRequest;
import com.atlassian.bitbucket.internal.defaultreviewers.rest.RestPullRequestCondition;
import com.atlassian.bitbucket.repository.NoSuchBranchException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Comparator;
import java.util.List;

@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Tag(name="Pull Requests")
@LicensedOnly
@Path(value="projects/{projectKey}/repos/{repositorySlug}")
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DefaultReviewersRepositoryResource {
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final PullRequestConditionService pullRequestConditionService;
    private final I18nService i18nService;
    private final DefaultReviewersResourceHelper defaultReviewersResourceHelper;

    @Inject
    public DefaultReviewersRepositoryResource(I18nService i18nService, PullRequestConditionService pullRequestConditionService, RefService refService, RepositoryService repositoryService, DefaultReviewersResourceHelper defaultReviewersResourceHelper) {
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.pullRequestConditionService = pullRequestConditionService;
        this.i18nService = i18nService;
        this.defaultReviewersResourceHelper = defaultReviewersResourceHelper;
    }

    @Operation(description="Return a set of users who are required reviewers for pull requests created from the given source repository and ref to the given target ref in this repository.", summary="Get required reviewers for PR creation")
    @Parameters(value={@Parameter(name="sourceRepoId", description="The ID of the repository in which the source ref exists", in=ParameterIn.QUERY), @Parameter(name="targetRepoId", description="The ID of the repository in which the target ref exists", in=ParameterIn.QUERY), @Parameter(name="sourceRefId", description="The ID of the source ref", in=ParameterIn.QUERY), @Parameter(name="targetRefId", description="The ID of the target ref", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="The default reviewer pull request conditions associated with the given repository.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestPullRequestCondition.class)))}, responseCode="200"), @ApiResponse(description="The request was malformed.", content={@Content(schema=@Schema(implementation=RestErrors.class))}, responseCode="400")})
    @GET
    @Path(value="reviewers")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getReviewers(@QueryParam(value="sourceRepoId") int sourceRepoId, @QueryParam(value="targetRepoId") int targetRepoId, @QueryParam(value="sourceRefId") String sourceRefId, @QueryParam(value="targetRefId") String targetRefId) {
        if (sourceRefId == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.rest.source.id.required", new Object[0]));
        }
        if (targetRefId == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.rest.target.id.required", new Object[0]));
        }
        Repository sourceRepo = this.repositoryService.getById(sourceRepoId);
        if (sourceRepo == null) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.defaultreviewers.error.rest.source.repository.not.found", new Object[]{sourceRepoId})).build();
        }
        Repository targetRepo = this.repositoryService.getById(targetRepoId);
        if (targetRepo == null) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.defaultreviewers.error.rest.target.repository.not.found", new Object[]{targetRepoId})).build();
        }
        Ref sourceRef = this.getRef(sourceRepo, sourceRefId, null);
        Ref targetRef = this.getRef(targetRepo, targetRefId, (RefType)StandardRefType.BRANCH);
        List reviewers = (List)this.pullRequestConditionService.getReviewers(targetRepo, sourceRef, targetRef).stream().map(RestApplicationUser::new).sorted(Comparator.comparing(RestApplicationUser::getDisplayName, String::compareToIgnoreCase)).collect(MoreCollectors.toImmutableList());
        return ResponseFactory.ok((Object)reviewers).build();
    }

    @Operation(description="Create a default reviewer pull request condition for the given repository.", summary="Create default reviewer condition")
    @ResponseDocs(value={@ResponseDoc(documentation="The default reviewer pull request condition that was created.", representation=RestPullRequestCondition.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true)})
    @RequestBody(description="The details needed to create a default reviewer pull request condition.", content={@Content(schema=@Schema(implementation=RestDefaultReviewersRequest.class))})
    @POST
    @Path(value="condition")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createPullRequestCondition(@BeanParam ScopeResolver scopeResolver, RestDefaultReviewersRequest request) {
        return this.defaultReviewersResourceHelper.createPullRequestCondition(scopeResolver.getScope(), request);
    }

    @Operation(description="Delete the default reviewer pull request condition associated with the given ID.", summary="Delete default reviewer condition")
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating that the pull request condition was deleted", responseCode=204), @ResponseDoc(documentation="An empty response indicating a pull request condition with the given ID could not be found.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="condition/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deletePullRequestCondition(@BeanParam ScopeResolver scopeResolver, @PathParam(value="id") int id) {
        return this.defaultReviewersResourceHelper.deletePullRequestCondition(scopeResolver.getScope(), id);
    }

    @Operation(description="Return a page of default reviewer pull request conditions that have been configured for this repository.", summary="Get default reviewer conditions")
    @ApiResponse(description="The default reviewer pull request conditions associated with the given repository.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestPullRequestCondition.class)))}, responseCode="200")
    @GET
    @Path(value="conditions")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequestConditions(@BeanParam ScopeResolver scopeResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        return this.defaultReviewersResourceHelper.getPullRequestConditions(scopeResolver.getScope(), pageRequestResolver.getPageRequest());
    }

    @Operation(description="Update the default reviewer pull request condition for the given ID.", summary="Update default reviewer condition")
    @Parameter(name="id", description="The ID of the pull request condition", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The updated default reviewer pull request condition.", representation=RestPullRequestCondition.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true)})
    @PUT
    @Path(value="condition/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updatePullRequestCondition(@BeanParam ScopeResolver scopeResolver, @PathParam(value="id") int id, RestDefaultReviewersRequest request) {
        return this.defaultReviewersResourceHelper.updatePullRequestCondition(scopeResolver.getScope(), id, request);
    }

    private Ref getRef(Repository repository, String refId, RefType refType) {
        Ref ref = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(refId).type(refType).build());
        if (ref == null) {
            throw new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.defaultreviewers.error.invalid.ref", new Object[]{repository.getProject().getKey(), repository.getSlug(), refId}), refId);
        }
        return ref;
    }
}

