/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.rest;

import com.atlassian.bitbucket.dmz.rest.v2.pull.reviewer.RestReviewerGroup;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.defaultreviewers.PullRequestConditionService;
import com.atlassian.bitbucket.internal.defaultreviewers.model.PullRequestCondition;
import com.atlassian.bitbucket.internal.defaultreviewers.rest.RestDefaultReviewersRequest;
import com.atlassian.bitbucket.internal.defaultreviewers.rest.RestPullRequestCondition;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProviderRegistry;
import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DefaultReviewersResourceHelper {
    private final I18nService i18nService;
    private final PullRequestConditionService pullRequestConditionService;
    private final RefMatcherProviderRegistry refMatcherProviderRegistry;

    public DefaultReviewersResourceHelper(I18nService i18nService, PullRequestConditionService pullRequestConditionService, RefMatcherProviderRegistry refMatcherProviderRegistry) {
        this.i18nService = i18nService;
        this.pullRequestConditionService = pullRequestConditionService;
        this.refMatcherProviderRegistry = refMatcherProviderRegistry;
    }

    public Response createPullRequestCondition(@Context Scope scope, RestDefaultReviewersRequest request) {
        this.validateMatcher(request.getSourceMatcher(), "bitbucket.defaultreviewers.error.rest.source.matcher.required");
        this.validateMatcher(request.getTargetMatcher(), "bitbucket.defaultreviewers.error.rest.target.matcher.required");
        PullRequestCondition pullRequestCondition = this.pullRequestConditionService.createPullRequestCondition(scope, this.getRefMatcher(scope, this.getSourceMatcher(request)), this.getRefMatcher(scope, request.getTargetMatcher()), DefaultReviewersResourceHelper.getReviewers(request), DefaultReviewersResourceHelper.getReviewerGroups(request), request.getRequiredApprovals());
        RestPullRequestCondition condition = new RestPullRequestCondition(pullRequestCondition);
        return ResponseFactory.ok((Object)((Object)condition)).build();
    }

    public Response deletePullRequestCondition(Scope scope, int id) {
        this.pullRequestConditionService.removePullRequestCondition(scope, id);
        return ResponseFactory.ok().build();
    }

    public Response getPullRequestConditions(Scope scope, PageRequest pageRequest) {
        List conditions = (List)this.pullRequestConditionService.getPullRequestConditions(scope, pageRequest).stream().map(RestPullRequestCondition::new).sorted(Comparator.comparingInt(RestPullRequestCondition::getId)).collect(MoreCollectors.toImmutableList());
        return ResponseFactory.ok((Object)conditions).build();
    }

    public Response updatePullRequestCondition(Scope scope, int id, RestDefaultReviewersRequest request) {
        RestRefMatcher sourceMatcher = this.getSourceMatcher(request);
        RestRefMatcher targetMatcher = this.getTargetMatcher(request);
        try {
            RestPullRequestCondition condition = new RestPullRequestCondition(this.pullRequestConditionService.updatePullRequestCondition(scope, id, this.getRefMatcher(scope, sourceMatcher), this.getRefMatcher(scope, targetMatcher), DefaultReviewersResourceHelper.getReviewers(request), DefaultReviewersResourceHelper.getReviewerGroups(request), request.getRequiredApprovals()));
            return ResponseFactory.ok((Object)((Object)condition)).build();
        }
        catch (IllegalStateException e) {
            return ResponseFactory.error((Response.Status)Response.Status.CONFLICT, (String)"pullRequestCondition", (String)"Pull request condition already exists").build();
        }
    }

    private static Set<Long> getReviewerGroups(RestDefaultReviewersRequest request) {
        Collection<RestReviewerGroup> reviewerGroups = request.getReviewerGroups();
        return reviewerGroups == null ? null : (Set)reviewerGroups.stream().map(RestReviewerGroup::getId).collect(MoreCollectors.toImmutableSet());
    }

    private static Set<Integer> getReviewers(RestDefaultReviewersRequest request) {
        Collection<RestApplicationUser> reviewers = request.getReviewers();
        return reviewers == null ? null : (Set)reviewers.stream().map(RestApplicationUser::getId).collect(MoreCollectors.toImmutableSet());
    }

    private RefMatcher getRefMatcher(Scope scope, RestRefMatcher restRefMatcher) {
        return (RefMatcher)Optional.ofNullable(this.refMatcherProviderRegistry.getProvider(restRefMatcher.getType().getId())).flatMap(refMatcherProvider -> refMatcherProvider.create(scope, restRefMatcher.getId())).orElseThrow(() -> new RuntimeException("Error getting ref matcher"));
    }

    private RestRefMatcher getSourceMatcher(RestDefaultReviewersRequest request) {
        RestRefMatcher matcher = request.getSourceMatcher();
        this.validateMatcher(matcher, "bitbucket.defaultreviewers.error.rest.source.matcher.required");
        return matcher;
    }

    private RestRefMatcher getTargetMatcher(RestDefaultReviewersRequest request) {
        RestRefMatcher matcher = request.getTargetMatcher();
        this.validateMatcher(matcher, "bitbucket.defaultreviewers.error.rest.target.matcher.required");
        return matcher;
    }

    private void validateMatcher(RestRefMatcher matcher, String messageKey) {
        if (matcher == null || matcher.getType() == null || matcher.getId() == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage(messageKey, new Object[0]));
        }
    }
}

