/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.rest;

import com.atlassian.bitbucket.dmz.rest.v2.pull.reviewer.RestReviewerGroup;
import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.Collection;

@JsonSerialize
public class RestDefaultReviewersRequest
extends RestMapEntity {
    private static final String REQUIRED_APPROVALS = "requiredApprovals";
    private static final String REVIEWER_GROUPS = "reviewerGroups";
    private static final String REVIEWERS = "reviewers";
    private static final String SOURCE_MATCHER = "sourceMatcher";
    private static final String TARGET_MATCHER = "targetMatcher";

    @Schema(example="1")
    public int getRequiredApprovals() {
        return this.getIntProperty(REQUIRED_APPROVALS);
    }

    @Nullable
    @ArraySchema(schema=@Schema(implementation=RestReviewerGroup.class, description="The list of RestReviewerGroup objects for this condition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED))
    public Collection<RestReviewerGroup> getReviewerGroups() {
        Object reviewerGroups = this.get(REVIEWER_GROUPS);
        if (reviewerGroups instanceof Collection) {
            Collection users = (Collection)reviewerGroups;
            return (Collection)users.stream().map(RestReviewerGroup::valueOf).collect(MoreCollectors.toImmutableSet());
        }
        return null;
    }

    @Nullable
    @ArraySchema(schema=@Schema(implementation=RestApplicationUser.class, description="The list of RestApplicationUser objects for this condition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED))
    public Collection<RestApplicationUser> getReviewers() {
        Object reviewers = this.get(REVIEWERS);
        if (reviewers instanceof Collection) {
            Collection users = (Collection)reviewers;
            return (Collection)users.stream().map(RestApplicationUser::valueOf).collect(MoreCollectors.toImmutableSet());
        }
        return null;
    }

    @Nullable
    public RestRefMatcher getSourceMatcher() {
        return RestRefMatcher.valueOf((Object)this.get(SOURCE_MATCHER));
    }

    @Nullable
    public RestRefMatcher getTargetMatcher() {
        return RestRefMatcher.valueOf((Object)this.get(TARGET_MATCHER));
    }
}

