/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaultreviewers.rest;

import com.atlassian.bitbucket.dmz.rest.v2.pull.reviewer.RestReviewerGroup;
import com.atlassian.bitbucket.internal.defaultreviewers.model.PullRequestCondition;
import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;

public class RestPullRequestCondition
extends RestMapEntity {
    private static final String ID = "id";
    private static final String REQUIRED_APPROVALS = "requiredApprovals";
    private static final String REVIEWER_GROUPS = "reviewerGroups";
    private static final String REVIEWERS = "reviewers";
    private static final String SCOPE = "scope";
    private static final String SOURCE_REF_MATCHER = "sourceRefMatcher";
    private static final String TARGET_REF_MATCHER = "targetRefMatcher";

    public RestPullRequestCondition() {
    }

    public RestPullRequestCondition(@Nonnull PullRequestCondition pullRequestCondition) {
        Objects.requireNonNull(pullRequestCondition);
        this.put(ID, pullRequestCondition.getId());
        this.put(SCOPE, new RestScope(pullRequestCondition.getScope()));
        this.put(SOURCE_REF_MATCHER, new RestRefMatcher(pullRequestCondition.getSourceMatcher()));
        this.put(TARGET_REF_MATCHER, new RestRefMatcher(pullRequestCondition.getTargetMatcher()));
        this.put(REVIEWER_GROUPS, pullRequestCondition.getReviewerGroups().stream().map(RestReviewerGroup::new).sorted(Comparator.comparing(RestReviewerGroup::getName, String::compareToIgnoreCase)).toList());
        this.put(REVIEWERS, pullRequestCondition.getReviewers().stream().map(RestApplicationUser::new).sorted(Comparator.comparing(RestApplicationUser::getDisplayName, String::compareToIgnoreCase)).toList());
        this.put(REQUIRED_APPROVALS, pullRequestCondition.getRequiredApprovals());
    }

    @Schema(example="1", accessMode=Schema.AccessMode.READ_ONLY)
    public int getId() {
        return this.getIntProperty(ID);
    }

    @Schema(example="1")
    public int getRequiredApprovals() {
        return this.getIntProperty(REQUIRED_APPROVALS);
    }

    @ArraySchema(schema=@Schema(description="The list of reviewer groups that have been specified for this condition.", implementation=RestReviewerGroup.class))
    public Collection<RestReviewerGroup> getReviewerGroups() {
        return (Collection)this.get(REVIEWER_GROUPS);
    }

    @ArraySchema(schema=@Schema(description="The list of reviewers that have been specified for this condition.", implementation=RestReviewerGroup.class))
    public Collection<RestApplicationUser> getReviewers() {
        return (Collection)this.get(REVIEWERS);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestScope getScope() {
        return (RestScope)this.get(SCOPE);
    }

    public RestRefMatcher getSourceRefMatcher() {
        return (RestRefMatcher)this.get(SOURCE_REF_MATCHER);
    }

    public RestRefMatcher getTargetRefMatcher() {
        return (RestRefMatcher)this.get(TARGET_REF_MATCHER);
    }
}

