/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.api;

import com.atlassian.secrets.api.RotationStatus;
import com.atlassian.secrets.api.SecretKey;
import com.atlassian.secrets.api.SecretServiceConfiguration;
import com.atlassian.secrets.api.SecretServiceDisabledException;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceState;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface SecretService {
    public static final String SECRET_SERVICE_STATE_SYSTEM_PROP = "atlassian.secret.service.state";

    public void put(String var1, String var2) throws SecretServiceException;

    default public void put(Map<String, String> secrets) throws SecretServiceException {
        for (Map.Entry<String, String> entry : secrets.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Optional<String> get(String var1) throws SecretServiceException;

    default public Map<String, Optional<String>> get(Set<String> identifiers) throws SecretServiceException {
        HashMap<String, Optional<String>> result = new HashMap<String, Optional<String>>();
        for (String identifier : identifiers) {
            result.put(identifier, this.get(identifier));
        }
        return result;
    }

    public void delete(String var1) throws SecretServiceException;

    default public void delete(Set<String> identifiers) throws SecretServiceException {
        for (String identifier : identifiers) {
            this.delete(identifier);
        }
    }

    default public SecretServiceManagement getManagement() {
        throw new UnsupportedOperationException("Management of SecretService not permitted");
    }

    public SecretServiceConfiguration getConfiguration() throws SecretServiceDisabledException;

    public static SecretServiceState getState() throws SecretServiceException {
        String sysPropValue = System.getProperty(SECRET_SERVICE_STATE_SYSTEM_PROP, "enabled");
        return sysPropValue.isBlank() ? SecretServiceState.ENABLED : SecretServiceState.fromTextValue(sysPropValue);
    }

    public static interface SecretServiceManagement {
        public RotationStatus rotateAESKey() throws SecretServiceException;

        public void reloadConfiguration() throws SecretServiceException;

        public Set<SecretKey> getInactiveKeys() throws SecretServiceException;
    }
}

