/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.x509.DmzX509Certificate;
import com.atlassian.bitbucket.dmz.x509.DmzX509CertificateService;
import com.atlassian.bitbucket.dmz.x509.DmzX509CertificateSupplier;
import com.atlassian.bitbucket.dmz.x509.X509CertificateAlreadyExistsException;
import com.atlassian.bitbucket.dmz.x509.X509CertificateIOException;
import com.atlassian.bitbucket.dmz.x509.X509CertificateNotFoundException;
import com.atlassian.bitbucket.dmz.x509.event.X509CertificateCreatedEvent;
import com.atlassian.bitbucket.dmz.x509.event.X509CertificateDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.x509.X509CertificateFactory;
import com.atlassian.bitbucket.internal.x509.X509RevokedCertificateHelper;
import com.atlassian.bitbucket.internal.x509.dao.X509CertificateDao;
import com.atlassian.bitbucket.internal.x509.model.InternalX509Certificate;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.annotation.Unsecured;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.security.access.annotation.Secured;
import org.springframework.transaction.annotation.Transactional;

@RequireFeature(value=StandardFeature.X509_CERTIFICATE_SIGNING)
public class DefaultX509CertificateService
implements DmzX509CertificateService {
    static final int CERTIFICATE_PAGE_SIZE = 500;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final X509CertificateDao x509CertificateDao;
    private final X509CertificateFactory x509CertificateFactory;
    private final X509RevokedCertificateHelper x509RevokedCertificateHelper;

    public DefaultX509CertificateService(EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, X509CertificateDao x509CertificateDao, X509CertificateFactory x509CertificateFactory, X509RevokedCertificateHelper x509RevokedCertificateHelper) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.x509CertificateDao = x509CertificateDao;
        this.x509CertificateFactory = x509CertificateFactory;
        this.x509RevokedCertificateHelper = x509RevokedCertificateHelper;
    }

    @Nonnull
    @Secured(value={"Secured internally by an explicit permission check"})
    @Transactional
    public DmzX509Certificate create(@Nonnull DmzX509CertificateSupplier certificateSupplier) throws X509CertificateIOException {
        byte[] encodedCertificate;
        Objects.requireNonNull(certificateSupplier, "certificateSupplier");
        this.requireGlobalAdmin();
        X509Certificate x509Certificate = this.generateX509Certificate((InputSupplier<InputStream>)certificateSupplier);
        try {
            encodedCertificate = x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new X509CertificateIOException(this.i18nService.createKeyedMessage("bitbucket.service.x509.certificate.encoding.invalid", new Object[]{x509Certificate, e}));
        }
        String fingerprint = DigestUtils.sha256Hex((byte[])encodedCertificate);
        Optional<InternalX509Certificate> existingCertificate = this.x509CertificateDao.getByFingerprint(fingerprint);
        if (existingCertificate.isPresent()) {
            throw new X509CertificateAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.service.x509.certificate.exists", new Object[]{fingerprint}));
        }
        InternalX509Certificate internalCertificate = new InternalX509Certificate.Builder().encoded(encodedCertificate).fingerprint(fingerprint).build();
        DmzX509Certificate certificate = (DmzX509Certificate)this.x509CertificateDao.create(internalCertificate);
        this.eventPublisher.publish((Object)new X509CertificateCreatedEvent((Object)this, certificate));
        this.x509RevokedCertificateHelper.updateRevokedCertificates(internalCertificate, x509Certificate);
        return certificate;
    }

    @Secured(value={"Secured internally by an explicit permission check"})
    @Transactional
    public void delete(long id) {
        this.requireGlobalAdmin();
        InternalX509Certificate certificate = (InternalX509Certificate)this.x509CertificateDao.getById(id);
        if (certificate == null) {
            throw new X509CertificateNotFoundException(this.i18nService.createKeyedMessage("bitbucket.service.x509.certificate.not.found", new Object[]{id}));
        }
        this.x509CertificateDao.deleteById(id);
        this.eventPublisher.publish((Object)new X509CertificateDeletedEvent((Object)this, (DmzX509Certificate)certificate));
    }

    @Nonnull
    @Secured(value={"Secured internally by an explicit permission check"})
    @Transactional(readOnly=true)
    public Page<DmzX509Certificate> findAll(@Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.requireGlobalAdmin();
        return PageUtils.asPageOf(DmzX509Certificate.class, (Page)this.x509CertificateDao.findAll(pageRequest));
    }

    @Unsecured(value="Internal only method")
    @Transactional
    public void runRevokedCertificatesUpdateJob() {
        PageUtils.toStream(arg_0 -> ((X509CertificateDao)this.x509CertificateDao).findAll(arg_0), (int)500).forEach(internalCertificate -> {
            byte[] encodedCertificate = internalCertificate.getEncoded();
            X509Certificate x509Certificate = this.generateX509Certificate(encodedCertificate);
            this.x509RevokedCertificateHelper.updateRevokedCertificates((InternalX509Certificate)internalCertificate, x509Certificate);
        });
    }

    @Secured(value={"Secured internally by an explicit permission check"})
    @Transactional
    public void updateRevokedCertificates(long id) {
        this.requireGlobalAdmin();
        InternalX509Certificate issuerCertificate = (InternalX509Certificate)this.x509CertificateDao.getById(id);
        if (issuerCertificate == null) {
            throw new X509CertificateNotFoundException(this.i18nService.createKeyedMessage("bitbucket.service.x509.certificate.not.found", new Object[]{id}));
        }
        X509Certificate x509Certificate = this.generateX509Certificate(issuerCertificate.getEncoded());
        this.x509RevokedCertificateHelper.updateRevokedCertificates(issuerCertificate, x509Certificate);
    }

    private X509Certificate generateX509Certificate(byte[] content) {
        return this.generateX509Certificate((InputSupplier<InputStream>)((InputSupplier)() -> new ByteArrayInputStream(content)));
    }

    private X509Certificate generateX509Certificate(InputSupplier<InputStream> content) {
        X509Certificate x509Certificate;
        block9: {
            InputStream inputStream = (InputStream)content.open();
            try {
                x509Certificate = this.x509CertificateFactory.generateCertificate(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CertificateException e) {
                    throw new X509CertificateIOException(this.i18nService.createKeyedMessage("bitbucket.service.x509.certificate.parse.failed", new Object[]{e}));
                }
                catch (IOException e) {
                    throw new X509CertificateIOException(this.i18nService.createKeyedMessage("bitbucket.service.x509.certificate.read.failed", new Object[]{e}));
                }
            }
            inputStream.close();
        }
        return x509Certificate;
    }

    private void requireGlobalAdmin() {
        if (!this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.x509.certificate.permissions.insufficient", new Object[0]));
        }
    }
}

