/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509;

import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class X509CertificateFactory {
    private final CertificateFactory certificateFactory = this.initializeCertificateFactory();

    @Nonnull
    public X509Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        return (X509Certificate)this.certificateFactory.generateCertificate(inputStream);
    }

    @Nonnull
    public X509CRL generateCrl(InputStream inputStream) throws CRLException {
        return (X509CRL)this.certificateFactory.generateCRL(inputStream);
    }

    private CertificateFactory initializeCertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException | CertificateException e) {
            throw new IllegalStateException("Failed to initialize the X.509 certificate factory", e);
        }
    }
}

