/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.x509.DmzX509CertificateService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateRevocationListUpdateJob
implements ScheduledJobSource {
    static final String JOB_NAME = "X509CertificateRevocationListUpdateJob";
    @VisibleForTesting
    static final JobId JOB_ID = JobId.of((String)"X509CertificateRevocationListUpdateJob");
    @VisibleForTesting
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)"X509CertificateRevocationListUpdateJob");
    @VisibleForTesting
    static final String LOCK_NAME = X509CertificateRevocationListUpdateJob.class.getSimpleName();
    private static final Logger log = LoggerFactory.getLogger(X509CertificateRevocationListUpdateJob.class);
    private final DmzX509CertificateService certificateService;
    private final LockService lockService;

    public X509CertificateRevocationListUpdateJob(DmzX509CertificateService certificateService, LockService lockService) {
        this.certificateService = certificateService;
        this.lockService = lockService;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) {
        Objects.requireNonNull(schedulerService, "schedulerService");
        X509CertificateRevocationListUpdateJobRunner jobRunner = new X509CertificateRevocationListUpdateJobRunner();
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)jobRunner);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)ImmutableMap.of((Object)"feature", (Object)StandardFeature.X509_CERTIFICATE_SIGNING)).withSchedule(Schedule.forInterval((long)Duration.ofDays(1L).toMillis(), (Date)new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L))));
        try {
            log.debug("Scheduling X.509 certification revocation list update job.");
            schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule X.509 certification revocation list update job.", (Throwable)e);
        }
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        Objects.requireNonNull(schedulerService, "schedulerService");
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private class X509CertificateRevocationListUpdateJobRunner
    implements JobRunner {
        private X509CertificateRevocationListUpdateJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(JobRunnerRequest request) {
            try (LockGuard guard = LockGuard.tryLock((Lock)X509CertificateRevocationListUpdateJob.this.lockService.getLock(LOCK_NAME));){
                if (guard == null) {
                    log.debug("Unable to acquire lock for updating the list of revoked X.509 certificates. Job may be already running on another node.");
                } else {
                    log.debug("Automatically updating the list of revoked X.509 certificates.");
                    X509CertificateRevocationListUpdateJob.this.certificateService.runRevokedCertificatesUpdateJob();
                }
            }
            catch (RuntimeException e) {
                return JobRunnerResponse.failed((Throwable)e);
            }
            return JobRunnerResponse.success((String)"Finished updating the list of revoked X.509 certificates.");
        }
    }
}

