/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509;

import com.atlassian.bitbucket.dmz.signature.verification.SignatureState;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationPublicKey;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationRequest;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationResult;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerifier;
import com.atlassian.bitbucket.internal.x509.X509CertificateFactory;
import com.atlassian.bitbucket.internal.x509.X509CertificatePublicKey;
import com.atlassian.bitbucket.internal.x509.dao.X509CertificateDao;
import com.atlassian.bitbucket.internal.x509.dao.X509RevokedCertificateDao;
import com.atlassian.bitbucket.internal.x509.model.InternalX509Certificate;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.StoreException;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.EncoderException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class X509CertificateSignatureVerifier
implements SignatureVerifier {
    @VisibleForTesting
    static final String ISSUER_CN = "x509_issuer_cn";
    @VisibleForTesting
    static final String ISSUER_O = "x509_issuer_o";
    @VisibleForTesting
    static final String ISSUER_OU = "x509_issuer_ou";
    @VisibleForTesting
    static final String ISSUER_SKI = "x509_issuer_ski";
    @VisibleForTesting
    static final String SIGNER_CN = "x509_signer_cn";
    @VisibleForTesting
    static final String SIGNER_O = "x509_signer_o";
    @VisibleForTesting
    static final String SIGNER_SHA1 = "x509_signer_sha1";
    @VisibleForTesting
    static final String SIGNER_SKI = "x509_signer_ski";
    @VisibleForTesting
    static final String X509_SIGNATURE_TYPE = "X509";
    private static final Logger log = LoggerFactory.getLogger(X509CertificateSignatureVerifier.class);
    private static final String X509_CERTIFICATE_HEADER = "-----BEGIN SIGNED MESSAGE-----";
    private final TransactionTemplate readOnlyTransaction;
    private final Cache<Long, Set<InternalX509Certificate>> signingCertificateMatchingIssuerCache;
    private final LoadingCache<Map<String, Long>, Boolean> signingCertificateRevokedCache;
    private final LoadingCache<String, Optional<ApplicationUser>> signingCertificateUserCache;
    private final X509CertificateDao x509CertificateDao;
    private final X509CertificateFactory x509CertificateFactory;

    public X509CertificateSignatureVerifier(int revokedSigningCertCacheSize, int signingCertMatchingIssuerCacheSize, int signingCertUserCacheSize, PlatformTransactionManager transactionManager, final UserService userService, X509CertificateDao x509CertificateDao, X509CertificateFactory x509CertificateFactory, final X509RevokedCertificateDao x509RevokedCertificateDao) {
        this.x509CertificateDao = x509CertificateDao;
        this.x509CertificateFactory = x509CertificateFactory;
        this.readOnlyTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.signingCertificateRevokedCache = CacheBuilder.newBuilder().maximumSize((long)revokedSigningCertCacheSize).build((CacheLoader)new CacheLoader<Map<String, Long>, Boolean>(){

            public Boolean load(@Nonnull Map<String, Long> revocationPredicates) {
                Long serialNumber = revocationPredicates.get("serialNumber");
                Long issuerId = revocationPredicates.get("issuerId");
                return (Boolean)X509CertificateSignatureVerifier.this.readOnlyTransaction.execute(result -> x509RevokedCertificateDao.existsBySerialNumberAndIssuerId(serialNumber, issuerId));
            }
        });
        this.signingCertificateMatchingIssuerCache = CacheBuilder.newBuilder().maximumSize((long)signingCertMatchingIssuerCacheSize).build();
        this.signingCertificateUserCache = CacheBuilder.newBuilder().maximumSize((long)signingCertUserCacheSize).build((CacheLoader)new CacheLoader<String, Optional<ApplicationUser>>(){

            public Optional<ApplicationUser> load(@Nonnull String emailAddress) {
                return Optional.ofNullable((ApplicationUser)X509CertificateSignatureVerifier.this.readOnlyTransaction.execute(result -> userService.findUserByEmail(emailAddress)));
            }
        });
    }

    @Nonnull
    public Optional<SignatureVerificationResult> verifySignature(@Nonnull SignatureVerificationRequest request) {
        X509Certificate signingCertificate;
        byte[] signingCertificateEncoded;
        Collection certificateHolders;
        Objects.requireNonNull(request, "request");
        String signature = request.getSignature();
        if (!X509CertificateSignatureVerifier.isX509CertificateSignature(signature)) {
            return Optional.empty();
        }
        CMSSignedData signedData = X509CertificateSignatureVerifier.getCmsSignedData(signature, request.getSignedContent());
        if (signedData == null) {
            log.debug("Signed object data was null and verification could not be performed");
            return X509CertificateSignatureVerifier.buildErrorSignatureVerificationResult();
        }
        Collection<SignerInformation> signers = X509CertificateSignatureVerifier.getSigners(signedData);
        if (signers.isEmpty()) {
            return X509CertificateSignatureVerifier.buildErrorSignatureVerificationResult();
        }
        if (signers.size() > 1) {
            log.debug("More than one signer was found in the signer information store for the signed data. Only the first signer will be used for verification of the Git object.");
        }
        SignerInformation signerInformation = signers.iterator().next();
        SignerId signerId = signerInformation.getSID();
        Store certificateHolderStore = signedData.getCertificates();
        try {
            certificateHolders = certificateHolderStore.getMatches((Selector)signerId);
        }
        catch (StoreException e) {
            log.error("Could not match the signer information with X.509 certificate store when verifying the Git object signature. Cannot perform X.509 signature verification.", (Throwable)e);
            return X509CertificateSignatureVerifier.buildErrorSignatureVerificationResult();
        }
        if (certificateHolders.isEmpty()) {
            log.warn("No X.509 certificate information could be found for the signer on the signed Git object. Cannot perform X.509 signature verification.");
            return X509CertificateSignatureVerifier.buildErrorSignatureVerificationResult();
        }
        if (certificateHolders.size() > 1) {
            log.debug("More than one X.509certificate was found in the X.509 certificate holder store for the signed Git object for that signer. Only the first X.509 certificate will be used for verification of the Git object.");
        }
        X509CertificateHolder certificateHolder = (X509CertificateHolder)certificateHolders.iterator().next();
        try {
            signingCertificateEncoded = certificateHolder.getEncoded();
        }
        catch (IOException e) {
            log.debug("Could not get the encoded format of the X.509 certificate for verifying the Git object signature. Cannot perform X.509 signature verification.", (Throwable)e);
            return X509CertificateSignatureVerifier.buildErrorSignatureVerificationResult();
        }
        try {
            signingCertificate = this.x509CertificateFactory.generateCertificate(new ByteArrayInputStream(signingCertificateEncoded));
        }
        catch (CertificateException e) {
            log.debug("Cannot perform any verification as the signing X.509 certificate could not be generated", (Throwable)e);
            return X509CertificateSignatureVerifier.buildErrorSignatureVerificationResult();
        }
        PublicKey signingCertificatePublicKey = signingCertificate.getPublicKey();
        Optional<ApplicationUser> signingCertificateOwner = this.getMatchingApplicationUser(signingCertificate, certificateHolder.getSubject());
        if (!signingCertificateOwner.isPresent()) {
            return Optional.of(new SignatureVerificationResult.Builder(SignatureState.ERROR).verificationPublicKey((SignatureVerificationPublicKey)new X509CertificatePublicKey(signingCertificatePublicKey)).signatureMetadata(X509CertificateSignatureVerifier.buildSignatureMetadata(signingCertificate, null)).signatureType(X509_SIGNATURE_TYPE).build());
        }
        long serialNumber = signingCertificate.getSerialNumber().longValue();
        ApplicationUser signingUser = signingCertificateOwner.get();
        Set<InternalX509Certificate> filteredCertificates = this.getFilteredCertificates(serialNumber, certificateHolder, (Store<X509CertificateHolder>)certificateHolderStore);
        return this.verifyCertificate(signingUser, filteredCertificates, signingCertificate, signingCertificatePublicKey, serialNumber, request.getObjectTimestamp().orElse(null));
    }

    private static Optional<SignatureVerificationResult> buildErrorSignatureVerificationResult() {
        return Optional.of(new SignatureVerificationResult.Builder(SignatureState.ERROR).signatureType(X509_SIGNATURE_TYPE).build());
    }

    private static Map<String, String> buildSignatureMetadata(X509Certificate signingCertificate, X509Certificate issuerCertificate) {
        Map<String, String> subjectDN;
        String subjectKeyIdentifier;
        ImmutableMap.Builder signatureMetadata = new ImmutableMap.Builder();
        if (signingCertificate != null) {
            subjectKeyIdentifier = X509CertificateSignatureVerifier.getSubjectKeyIdentifier(signingCertificate);
            if (subjectKeyIdentifier != null) {
                signatureMetadata.put((Object)SIGNER_SKI, (Object)subjectKeyIdentifier);
            }
            if (!(subjectDN = X509CertificateSignatureVerifier.includeCertificateSubjectDN(signingCertificate, false)).isEmpty()) {
                signatureMetadata.putAll(subjectDN);
            }
            try {
                signatureMetadata.put((Object)SIGNER_SHA1, (Object)new String(Hex.encode((byte[])DigestUtils.sha1((byte[])signingCertificate.getEncoded())), StandardCharsets.UTF_8).replaceAll("..", "$0 ").trim().toUpperCase(Locale.US));
            }
            catch (Exception e) {
                log.debug("Could not generate the SHA-1 fingerprint for the signing X.509 certificate");
            }
        }
        if (issuerCertificate != null) {
            subjectKeyIdentifier = X509CertificateSignatureVerifier.getSubjectKeyIdentifier(issuerCertificate);
            if (subjectKeyIdentifier != null) {
                signatureMetadata.put((Object)ISSUER_SKI, (Object)subjectKeyIdentifier);
            }
            if (!(subjectDN = X509CertificateSignatureVerifier.includeCertificateSubjectDN(issuerCertificate, true)).isEmpty()) {
                signatureMetadata.putAll(subjectDN);
            }
        }
        return signatureMetadata.build();
    }

    private static CMSSignedData getCmsSignedData(String signature, String signedContent) {
        byte[] transformedSignatureBytes;
        try {
            transformedSignatureBytes = Base64.decode((String)X509CertificateSignatureVerifier.transformSignature(signature));
        }
        catch (DecoderException e) {
            log.debug("Could not decode signature to be used for X.509 certificate signature verification.", (Throwable)e);
            return null;
        }
        try {
            CMSProcessableByteArray processableSignedContent = new CMSProcessableByteArray(signedContent.getBytes(StandardCharsets.UTF_8));
            return new CMSSignedData((CMSProcessable)processableSignedContent, transformedSignatureBytes);
        }
        catch (CMSException e) {
            log.debug("Could not construct the signed data object for X.509 certificate signature verification.", (Throwable)e);
            return null;
        }
    }

    private static Collection<SignerInformation> getSigners(CMSSignedData signedData) {
        SignerInformationStore signerInformationStore = signedData.getSignerInfos();
        if (signerInformationStore.size() == 0) {
            log.debug("Signer information store did not contain any signing information for the signed data.");
            return ImmutableList.of();
        }
        return signerInformationStore.getSigners();
    }

    private static SignatureState getSignerValidity(X509Certificate certificate, long certificateSerialNumber, Date committerTimestamp, String issuerFingerprint) {
        try {
            if (committerTimestamp == null) {
                log.debug("The committer timestamp is unexpectedly null. The signing X.509 certificate's validity period with serial number '{}' cannot be checked when verified against issuer X.509 certificate with fingerprint '{}'", (Object)certificateSerialNumber, (Object)issuerFingerprint);
                return SignatureState.GOOD_BUT_UNKNOWN_VALIDITY;
            }
            certificate.checkValidity(committerTimestamp);
            return SignatureState.GOOD;
        }
        catch (CertificateExpiredException e) {
            log.warn("The signing X.509 certificate with serial number '{}' has expired and should not be used for signing when verified against issuer X.509 certificate with fingerprint '{}': {}", new Object[]{certificateSerialNumber, issuerFingerprint, e.getMessage()});
            return SignatureState.GOOD_BUT_MADE_AFTER_EXPIRY;
        }
        catch (CertificateNotYetValidException e) {
            log.warn("The signing X.509 certificate with serial number '{}' has been issued but should not be used yet when verified against issuer X.509 certificate with fingerprint '{}': {}", new Object[]{certificateSerialNumber, issuerFingerprint, e.getMessage()});
            return SignatureState.GOOD_BUT_MADE_BEFORE_VALIDITY;
        }
    }

    private static String getSubjectKeyIdentifier(X509Certificate certificate) {
        ASN1Primitive asn1Primitive;
        ASN1OctetString subjectKeyIdAsn1;
        byte[] subjectKeyIdBytes = certificate.getExtensionValue(Extension.subjectKeyIdentifier.getId());
        if (subjectKeyIdBytes == null) {
            log.debug("No subject key identifier information was present for the X.509 certificate");
            return null;
        }
        try {
            ASN1Primitive primitive = ASN1Primitive.fromByteArray((byte[])subjectKeyIdBytes);
            subjectKeyIdAsn1 = ASN1OctetString.getInstance((Object)primitive);
        }
        catch (IOException e) {
            log.debug("Could not successfully parse the subject key identifier bytes");
            return null;
        }
        try {
            asn1Primitive = ASN1Primitive.fromByteArray((byte[])subjectKeyIdAsn1.getOctets());
        }
        catch (IOException e) {
            log.debug("Could not successfully parse the ASN1 subject key identifier bytes");
            return null;
        }
        SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance((Object)asn1Primitive);
        try {
            return new String(Hex.encode((byte[])subjectKeyIdentifier.getKeyIdentifier()), StandardCharsets.UTF_8).replaceAll("..", "$0 ").trim().toUpperCase(Locale.US);
        }
        catch (EncoderException e) {
            log.debug("Could not successfully encode the subject key identifier");
            return null;
        }
    }

    private static Map<String, String> includeCertificateSubjectDN(X509Certificate certificate, boolean isIssuer) {
        String[] splitSubjectDN;
        Principal principal = certificate.getSubjectDN();
        if (principal == null) {
            return Collections.emptyMap();
        }
        String subjectDN = principal.getName();
        if (StringUtils.isBlank((CharSequence)subjectDN)) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder subjectDNMap = new ImmutableMap.Builder();
        for (String subjectDNElement : splitSubjectDN = subjectDN.split(",")) {
            if (subjectDNElement.startsWith("CN=")) {
                subjectDNMap.put((Object)(isIssuer ? ISSUER_CN : SIGNER_CN), (Object)subjectDNElement);
                continue;
            }
            if (subjectDNElement.startsWith("O=")) {
                subjectDNMap.put((Object)(isIssuer ? ISSUER_O : SIGNER_O), (Object)subjectDNElement);
                continue;
            }
            if (!isIssuer || !subjectDNElement.startsWith("OU=")) continue;
            subjectDNMap.put((Object)ISSUER_OU, (Object)subjectDNElement);
        }
        return subjectDNMap.build();
    }

    private static boolean isX509CertificateSignature(String signature) {
        return signature.startsWith(X509_CERTIFICATE_HEADER);
    }

    private static String transformSignature(String signature) {
        return signature.replaceAll("-----([^\\s\\d]+) SIGNED MESSAGE-----\n", "");
    }

    private Optional<String> getEmailAddressFromSubjectAlternativeNameAttribute(X509Certificate signingCertificate) {
        try {
            Collection<List<?>> subjectAlternativeNames = signingCertificate.getSubjectAlternativeNames();
            return subjectAlternativeNames == null ? Optional.empty() : subjectAlternativeNames.stream().filter(entry -> entry.get(0).equals(1)).map(entry -> (String)entry.get(1)).findFirst();
        }
        catch (CertificateParsingException e) {
            log.debug("Could not successfully parse the SAN to find an email address for the signing certificate.");
            log.debug("No SAN RFC822 Name attribute could be found for the signing certificate.");
            return Optional.empty();
        }
    }

    private Optional<String> getEmailAddressFromX500Name(X500Name x500Name) {
        RDN rdn;
        if (x500Name == null) {
            log.debug("X500Name used to determine the signing X.509 certificate's owner is null.");
            return Optional.empty();
        }
        RDN[] emailRdns = x500Name.getRDNs(BCStyle.E);
        if (emailRdns.length != 0 && (rdn = emailRdns[0]) != null && rdn.getFirst() != null) {
            return Optional.of(IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue()));
        }
        log.debug("We could not find an email address for the X500Name entry '{}'.", (Object)x500Name);
        return Optional.empty();
    }

    private Set<InternalX509Certificate> getFilteredCertificates(long signingCertificateSerialNumber, X509CertificateHolder certificateHolder, Store<X509CertificateHolder> certificateHolderStore) {
        try {
            return (Set)this.signingCertificateMatchingIssuerCache.get((Object)signingCertificateSerialNumber, () -> {
                Set filteredCertificateFingerprints = (Set)certificateHolderStore.getMatches(null).stream().filter(holder -> !Objects.equals(holder, certificateHolder)).map(holder -> {
                    try {
                        return DigestUtils.sha256Hex((byte[])holder.getEncoded());
                    }
                    catch (IOException e) {
                        log.error("Could not determine the issuer's fingerprint for verifying the X.509 certificate with serial number '{}'", (Object)holder.getSerialNumber());
                        return null;
                    }
                }).filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
                if (filteredCertificateFingerprints.isEmpty()) {
                    log.debug("No filtered issuer X.509 certificate fingerprints were found. All the trusted X.509 certificates in the database will be checked when verifying the signature of the Git object.");
                    return ((Stream)this.readOnlyTransaction.execute(result -> PageUtils.toStream(arg_0 -> ((X509CertificateDao)this.x509CertificateDao).findAll(arg_0), (int)500))).collect(Collectors.toSet());
                }
                return (Set)this.readOnlyTransaction.execute(result -> this.x509CertificateDao.getByFingerprints(filteredCertificateFingerprints));
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            log.debug("Encountered an issue when determining the signing X.509 certificate's issuer information. All the trusted X.509 certificates in the database will be checked when verifying the signature of the Git object.");
            return ((Stream)this.readOnlyTransaction.execute(result -> PageUtils.toStream(arg_0 -> ((X509CertificateDao)this.x509CertificateDao).findAll(arg_0), (int)500))).collect(Collectors.toSet());
        }
    }

    private Optional<ApplicationUser> getMatchingApplicationUser(X509Certificate signingCertificate, X500Name x500Name) {
        Optional<String> emailAddress = this.getEmailAddressFromSubjectAlternativeNameAttribute(signingCertificate);
        if (!emailAddress.isPresent()) {
            emailAddress = this.getEmailAddressFromX500Name(x500Name);
        }
        if (!emailAddress.isPresent()) {
            log.debug("No email address could be found for the signing certificate. Cannot perform X.509 signature verification.");
            return Optional.empty();
        }
        try {
            return (Optional)this.signingCertificateUserCache.get((Object)emailAddress.get());
        }
        catch (ExecutionException e) {
            log.debug("Could not successfully match the email address to a user in the system.Cannot perform X.509 signature verification.");
            return Optional.empty();
        }
    }

    private Optional<SignatureVerificationResult> verifyCertificate(ApplicationUser certificateOwner, Set<InternalX509Certificate> filteredIssuerCertificates, X509Certificate signingCertificate, PublicKey signingCertificatePublicKey, long signingCertificateSerialNumber, Date committerTimestamp) {
        for (InternalX509Certificate issuerCertificate : filteredIssuerCertificates) {
            X509Certificate certificate;
            String issuerFingerprint = issuerCertificate.getFingerprint();
            log.debug("Attempting to verify signing X.509 certificate with serial number '{}' against issuer X.509 certificate with fingerprint '{}'", (Object)signingCertificateSerialNumber, (Object)issuerFingerprint);
            try {
                certificate = this.x509CertificateFactory.generateCertificate(new ByteArrayInputStream(issuerCertificate.getEncoded()));
            }
            catch (CertificateException e) {
                log.debug("Could not generate issuer X.509 certificate with fingerprint '{}' for verifying signing X.509 certificate with serial number '{}'", (Object)issuerFingerprint, (Object)signingCertificateSerialNumber);
                continue;
            }
            try {
                signingCertificate.verify(certificate.getPublicKey());
                Boolean isRevokedSigningCertificate = null;
                try {
                    ImmutableMap.Builder revokedCriteriaRestrictions = new ImmutableMap.Builder();
                    revokedCriteriaRestrictions.put((Object)"serialNumber", (Object)signingCertificateSerialNumber);
                    revokedCriteriaRestrictions.put((Object)"issuerId", (Object)issuerCertificate.getId());
                    isRevokedSigningCertificate = (Boolean)this.signingCertificateRevokedCache.get((Object)revokedCriteriaRestrictions.build());
                }
                catch (ExecutionException e) {
                    log.debug("Could not determine whether or not the signing X.509 certificate with serial number '{}' was revoked or not when verified against issuer X.509 certificate with fingerprint '{}'.", (Object)signingCertificateSerialNumber, (Object)issuerFingerprint);
                }
                if (Boolean.TRUE.equals(isRevokedSigningCertificate)) {
                    log.warn("The signing X.509 certificate with serial number '{}' has been revoked and should not be used when verified against issuer X.509 certificate with fingerprint '{}'.", (Object)signingCertificateSerialNumber, (Object)issuerFingerprint);
                    return Optional.of(new SignatureVerificationResult.Builder(SignatureState.GOOD_BUT_REVOKED).owner(certificateOwner).signatureMetadata(X509CertificateSignatureVerifier.buildSignatureMetadata(signingCertificate, certificate)).verificationPublicKey((SignatureVerificationPublicKey)new X509CertificatePublicKey(signingCertificatePublicKey)).signatureType(X509_SIGNATURE_TYPE).build());
                }
                return Optional.of(new SignatureVerificationResult.Builder(X509CertificateSignatureVerifier.getSignerValidity(signingCertificate, signingCertificateSerialNumber, committerTimestamp, issuerFingerprint)).owner(certificateOwner).signatureMetadata(X509CertificateSignatureVerifier.buildSignatureMetadata(signingCertificate, certificate)).signatureType(X509_SIGNATURE_TYPE).verificationPublicKey((SignatureVerificationPublicKey)new X509CertificatePublicKey(signingCertificatePublicKey)).build());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                log.debug("Could not correctly verify signing X.509 certificate with serial number '{}' using issuer X.509 certificate with fingerprint '{}'", (Object)signingCertificateSerialNumber, (Object)issuerFingerprint);
            }
            catch (SignatureException signatureException) {
            }
        }
        return Optional.of(new SignatureVerificationResult.Builder(SignatureState.GOOD_BUT_UNKNOWN_VALIDITY).owner(certificateOwner).signatureMetadata(X509CertificateSignatureVerifier.buildSignatureMetadata(signingCertificate, null)).signatureType(X509_SIGNATURE_TYPE).verificationPublicKey((SignatureVerificationPublicKey)new X509CertificatePublicKey(signingCertificatePublicKey)).build());
    }
}

