/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509;

import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerifier;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerifierFactory;
import com.atlassian.bitbucket.internal.x509.X509CertificateFactory;
import com.atlassian.bitbucket.internal.x509.X509CertificateSignatureVerifier;
import com.atlassian.bitbucket.internal.x509.dao.X509CertificateDao;
import com.atlassian.bitbucket.internal.x509.dao.X509RevokedCertificateDao;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.UserService;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.springframework.transaction.PlatformTransactionManager;

public class X509CertificateSignatureVerifierFactory
implements SignatureVerifierFactory {
    private final FeatureManager featureManager;
    private final int revokedSigningCertCacheSize;
    private final int signingCertMatchingIssuerCacheSize;
    private final int signingCertUserCacheSize;
    private final PlatformTransactionManager transactionManager;
    private final UserService userService;
    private final X509CertificateDao x509CertificateDao;
    private final X509CertificateFactory x509CertificateFactory;
    private final X509RevokedCertificateDao x509RevokedCertificateDao;

    public X509CertificateSignatureVerifierFactory(FeatureManager featureManager, int revokedSigningCertCacheSize, int signingCertMatchingIssuerCacheSize, int signingCertUserCacheSize, PlatformTransactionManager transactionManager, UserService userService, X509CertificateDao x509CertificateDao, X509CertificateFactory x509CertificateFactory, X509RevokedCertificateDao x509RevokedCertificateDao) {
        this.featureManager = featureManager;
        this.revokedSigningCertCacheSize = revokedSigningCertCacheSize;
        this.signingCertMatchingIssuerCacheSize = signingCertMatchingIssuerCacheSize;
        this.signingCertUserCacheSize = signingCertUserCacheSize;
        this.transactionManager = transactionManager;
        this.userService = userService;
        this.x509CertificateDao = x509CertificateDao;
        this.x509CertificateFactory = x509CertificateFactory;
        this.x509RevokedCertificateDao = x509RevokedCertificateDao;
    }

    @Nonnull
    public Optional<SignatureVerifier> createSignatureVerifier() {
        if (this.featureManager.isEnabled((Feature)StandardFeature.X509_CERTIFICATE_SIGNING)) {
            return Optional.of(new X509CertificateSignatureVerifier(this.revokedSigningCertCacheSize, this.signingCertMatchingIssuerCacheSize, this.signingCertUserCacheSize, this.transactionManager, this.userService, this.x509CertificateDao, this.x509CertificateFactory, this.x509RevokedCertificateDao));
        }
        return Optional.empty();
    }
}

