/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509HttpRequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(X509HttpRequestExecutor.class);
    private final HttpClient httpClient;
    private final HttpClientFactory httpClientFactory;

    public X509HttpRequestExecutor(HttpClientFactory httpClientFactory, int httpConnectionTimeout, int httpSocketTimeout) {
        HttpClientOptions options = new HttpClientOptions();
        options.setSocketTimeout(httpConnectionTimeout, TimeUnit.MILLISECONDS);
        options.setRequestTimeout(httpSocketTimeout, TimeUnit.MILLISECONDS);
        options.setSupportedProtocols(new String[]{"TLSv1.2"});
        this.httpClientFactory = httpClientFactory;
        this.httpClient = httpClientFactory.create(options);
    }

    public Response makeGetRequest(String url) {
        log.debug("Sending GET request to {}", (Object)url);
        return (Response)((Request.Builder)this.httpClient.newRequest(url).setContentType("application/pkix-crl")).get().claim();
    }

    @PreDestroy
    public void onStop() {
        try {
            this.httpClientFactory.dispose(this.httpClient);
        }
        catch (Exception e) {
            log.warn("Failed to dispose a HttpClient");
            log.debug("Dispose error:", (Throwable)e);
        }
    }
}

