/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.internal.x509.X509CertificateFactory;
import com.atlassian.bitbucket.internal.x509.X509HttpRequestExecutor;
import com.atlassian.bitbucket.internal.x509.dao.X509RevokedCertificateDao;
import com.atlassian.bitbucket.internal.x509.model.InternalX509Certificate;
import com.atlassian.bitbucket.internal.x509.model.InternalX509RevokedCertificate;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class X509RevokedCertificateHelper {
    private static final Logger log = LoggerFactory.getLogger(X509RevokedCertificateHelper.class);
    private final ExecutorService executorService;
    private final LockService lockService;
    private final TransactionTemplate readOnlyTransaction;
    private final TransactionTemplate readWriteTransaction;
    private final X509CertificateFactory x509CertificateFactory;
    private final X509HttpRequestExecutor x509HttpRequestExecutor;
    private final X509RevokedCertificateDao x509RevokedCertificateDao;

    public X509RevokedCertificateHelper(ExecutorService executorService, LockService lockService, PlatformTransactionManager transactionManager, X509CertificateFactory x509CertificateFactory, X509HttpRequestExecutor x509HttpRequestExecutor, X509RevokedCertificateDao x509RevokedCertificateDao) {
        this.executorService = executorService;
        this.x509HttpRequestExecutor = x509HttpRequestExecutor;
        this.lockService = lockService;
        this.x509CertificateFactory = x509CertificateFactory;
        this.x509RevokedCertificateDao = x509RevokedCertificateDao;
        this.readOnlyTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.readWriteTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0));
    }

    public void updateRevokedCertificates(@Nonnull InternalX509Certificate issuerCertificate, @Nonnull X509Certificate x509Certificate) {
        Objects.requireNonNull(issuerCertificate, "issuerCertificate");
        Objects.requireNonNull(x509Certificate, "x509Certificate");
        String issuerFingerprint = issuerCertificate.getFingerprint();
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(issuerFingerprint));){
            if (guard == null) {
                log.debug("Unable to acquire lock for updating the list of revoked X.509 certificates for X.509 certificate {}", (Object)issuerCertificate);
                return;
            }
            log.debug("Updating the list of revoked X.509 certificates for X.509 certificate {}", (Object)issuerCertificate);
            this.executorService.execute(() -> {
                MutableInt successCount = new MutableInt();
                MutableInt failCount = new MutableInt();
                Set<X509CRL> crls = this.getCrls(x509Certificate, this.x509CertificateFactory);
                crls.forEach(crl -> {
                    Set<? extends X509CRLEntry> revokedCertificates = crl.getRevokedCertificates();
                    if (revokedCertificates != null) {
                        revokedCertificates.forEach(revokedCertificate -> {
                            Boolean result = this.addIfNotPresent(issuerCertificate, (X509CRLEntry)revokedCertificate);
                            if (Boolean.TRUE.equals(result)) {
                                successCount.increment();
                            } else if (Boolean.FALSE.equals(result)) {
                                failCount.increment();
                            }
                        });
                    }
                });
                log.debug("Certificate revocation list update results for X.509 certificate {} - Successfully added {} new revoked X.509 certificate DB entries; Failed to add {} new revoked X.509 certificate DB entries", new Object[]{issuerCertificate, successCount.intValue(), failCount.intValue()});
            });
        }
    }

    @VisibleForTesting
    Boolean addIfNotPresent(InternalX509Certificate issuerCertificate, X509CRLEntry crlEntry) {
        long serialNumber = crlEntry.getSerialNumber().longValue();
        Optional revokedCertificate = (Optional)this.readOnlyTransaction.execute(result -> this.x509RevokedCertificateDao.getBySerialNumberAndIssuerId(serialNumber, issuerCertificate.getId()));
        if (!revokedCertificate.isPresent()) {
            InternalX509RevokedCertificate internalCertificate = new InternalX509RevokedCertificate.Builder().serialNumber(serialNumber).issuer(issuerCertificate).build();
            return (Boolean)this.readWriteTransaction.execute(status -> {
                this.x509RevokedCertificateDao.create(internalCertificate);
                return true;
            });
        }
        return null;
    }

    @VisibleForTesting
    Set<X509CRL> getCrls(X509Certificate certificate, X509CertificateFactory x509CertificateFactory) {
        ImmutableSet.Builder x509Crls = ImmutableSet.builder();
        for (String url : this.getCrlUrls(certificate)) {
            log.debug("Attempting to get the X.509 certificate revocation list information at URL '{}'", (Object)url);
            Response response = this.x509HttpRequestExecutor.makeGetRequest(url);
            if (response.isOk()) {
                try (InputStream inputStream = response.getEntityStream();){
                    X509CRL crl = x509CertificateFactory.generateCrl(inputStream);
                    x509Crls.add((Object)crl);
                }
                catch (IOException | CRLException e) {
                    log.warn("Failed to generate the certificate revocation list based on information at URL '{}' for X.509 certificate {}", new Object[]{url, certificate, e});
                }
                continue;
            }
            log.warn("Could not successfully obtain X.509 certificate revocation list information at URL '{}'", (Object)url);
        }
        return x509Crls.build();
    }

    @VisibleForTesting
    Set<String> getCrlUrls(X509Certificate certificate) {
        CRLDistPoint crlDistributionPoint;
        byte[] crlExtensionValue = certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        BigInteger serialNumber = certificate.getSerialNumber();
        if (crlExtensionValue == null || crlExtensionValue.length <= 0) {
            log.debug("X.509 certificate with serial number '{}' did not have any certificate revocation list distribution points", (Object)serialNumber);
            return Collections.emptySet();
        }
        try {
            crlDistributionPoint = CRLDistPoint.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])crlExtensionValue));
        }
        catch (IOException e) {
            log.debug("Failed to retrieve the certificate revocation list URLs for X.509 certificate with serial number '{}'", (Object)serialNumber, (Object)e);
            return Collections.emptySet();
        }
        return (Set)Arrays.stream(crlDistributionPoint.getDistributionPoints()).map(DistributionPoint::getDistributionPoint).filter(Objects::nonNull).filter(name -> name.getType() == 0).map(name -> GeneralNames.getInstance((Object)name.getName()).getNames()).flatMap(Arrays::stream).filter(name -> name.getTagNo() == 6).map(name -> ASN1IA5String.getInstance((Object)name.getName()).getString()).collect(MoreCollectors.toImmutableSet());
    }

    private static byte[] getEncoded(X509CRLEntry crlEntry) {
        try {
            return crlEntry.getEncoded();
        }
        catch (CRLException e) {
            log.warn("Failed to encode X.509 CRL entry {}", (Object)crlEntry, (Object)e);
            return null;
        }
    }
}

