/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509.dao;

import com.atlassian.bitbucket.internal.x509.dao.X509CertificateDao;
import com.atlassian.bitbucket.internal.x509.model.InternalX509Certificate;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.SessionFactory;

public class HibernateX509CertificateDao
extends AbstractHibernateDao<Long, InternalX509Certificate>
implements X509CertificateDao {
    public HibernateX509CertificateDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    @Nonnull
    public Optional<InternalX509Certificate> getByFingerprint(@Nonnull String fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        String hql = "from InternalX509Certificate where fingerprint = :fingerprint";
        return Optional.ofNullable((InternalX509Certificate)this.session().createQuery(hql, InternalX509Certificate.class).setParameter("fingerprint", (Object)fingerprint).uniqueResult());
    }

    @Override
    @Nonnull
    public Set<InternalX509Certificate> getByFingerprints(@Nonnull Set<String> fingerprints) {
        Objects.requireNonNull(fingerprints, "fingerprints");
        String hql = "from InternalX509Certificate where fingerprint in (:fingerprints) order by id asc";
        return ImmutableSet.copyOf((Collection)this.session().createQuery(hql, InternalX509Certificate.class).setParameter("fingerprints", fingerprints).list());
    }
}

