/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509.event;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.x509.DmzX509Certificate;
import com.atlassian.bitbucket.dmz.x509.event.X509CertificateCreatedEvent;
import com.atlassian.bitbucket.dmz.x509.event.X509CertificateDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class X509CertificateAuditingEventListener {
    @VisibleForTesting
    static final String ACTION_X509_CERTIFICATE_CREATED = "bitbucket.x509.certificate.audit.action.certificate.created";
    @VisibleForTesting
    static final String ACTION_X509_CERTIFICATE_DELETED = "bitbucket.x509.certificate.audit.action.certificate.deleted";
    @VisibleForTesting
    static final String ATTR_FINGERPRINT = "bitbucket.x509.certificate.audit.attribute.fingerprint";
    private final AuditService auditService;

    public X509CertificateAuditingEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onX509CertificateCreated(X509CertificateCreatedEvent event) {
        AuditEvent auditEvent = X509CertificateAuditingEventListener.getBuilder(ACTION_X509_CERTIFICATE_CREATED).extraAttributes(X509CertificateAuditingEventListener.getExtraAttributes(event.getCertificate())).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onX509CertificateDeleted(X509CertificateDeletedEvent event) {
        AuditEvent auditEvent = X509CertificateAuditingEventListener.getBuilder(ACTION_X509_CERTIFICATE_DELETED).extraAttributes(X509CertificateAuditingEventListener.getExtraAttributes(event.getCertificate())).build();
        this.auditService.audit(auditEvent);
    }

    private static AuditEvent.Builder getBuilder(String type) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)type).build();
        return AuditEvent.builder((AuditType)auditType);
    }

    private static List<AuditAttribute> getExtraAttributes(DmzX509Certificate certificate) {
        return ImmutableList.of((Object)AuditAttribute.fromI18nKeys((String)ATTR_FINGERPRINT, (String)certificate.getFingerprint()).build());
    }
}

