/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509.model;

import com.atlassian.bitbucket.dmz.x509.DmzX509Certificate;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Base64;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Entity
@Table(name="bb_x509_certificate")
@TableGenerator(allocationSize=5, pkColumnValue="bb_x509_certificate", name="x509CertificateIdGenerator", table="id_sequence")
public class InternalX509Certificate
implements DmzX509Certificate {
    public static final String COLUMN_ENCODED = "encoded_base64";
    public static final String COLUMN_FINGERPRINT = "fingerprint";
    public static final String COLUMN_ID = "id";
    public static final String ID_GEN = "x509CertificateIdGenerator";
    public static final int MAX_LOB_LENGTH = 32768;
    public static final String TABLE = "bb_x509_certificate";
    @Column(name="encoded_base64", nullable=false)
    @Lob
    @RequiredString(size=32768)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String encodedBase64;
    @Column(name="fingerprint", nullable=false, unique=true)
    private final String fingerprint;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="x509CertificateIdGenerator", strategy=GenerationType.TABLE)
    private final long id;

    protected InternalX509Certificate() {
        this.id = 0L;
        this.encodedBase64 = null;
        this.fingerprint = null;
    }

    private InternalX509Certificate(Builder builder) {
        this.encodedBase64 = Base64.getEncoder().encodeToString(builder.encoded);
        this.fingerprint = builder.fingerprint;
        this.id = builder.id;
    }

    @Nonnull
    public byte[] getEncoded() {
        return Base64.getDecoder().decode(this.encodedBase64);
    }

    @Nonnull
    public String getFingerprint() {
        return this.fingerprint;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(COLUMN_ID, this.id).add(COLUMN_FINGERPRINT, (Object)this.fingerprint).toString();
    }

    public static class Builder {
        private byte[] encoded;
        private String fingerprint;
        private long id;

        public Builder() {
            this.id = 0L;
        }

        public Builder(@Nonnull InternalX509Certificate certificate) {
            this.encoded = Objects.requireNonNull(certificate.getEncoded(), "encoded");
            this.fingerprint = Objects.requireNonNull(certificate.getFingerprint(), InternalX509Certificate.COLUMN_FINGERPRINT);
            this.id = certificate.getId();
        }

        @Nonnull
        public InternalX509Certificate build() {
            return new InternalX509Certificate(this);
        }

        @Nonnull
        public Builder encoded(@Nonnull byte[] value) {
            this.encoded = Objects.requireNonNull(value, "encoded");
            return this;
        }

        @Nonnull
        public Builder fingerprint(@Nonnull String value) {
            this.fingerprint = Objects.requireNonNull(value, InternalX509Certificate.COLUMN_FINGERPRINT);
            return this;
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }
    }
}

