/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.x509.model;

import com.atlassian.bitbucket.dmz.x509.DmzX509RevokedCertificate;
import com.atlassian.bitbucket.internal.x509.model.InternalX509Certificate;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Entity
@Table(name="bb_x509_revoked_certificate", indexes={@Index(name="idx_bb_x509_cert_issuer_id", columnList="issuer_id"), @Index(name="idx_bb_x509_cert_sn_issuer_id", columnList="serial_number, issuer_id")})
@TableGenerator(allocationSize=25, pkColumnValue="bb_x509_revoked_certificate", name="x509RevokedCertificateIdGenerator", table="id_sequence")
public class InternalX509RevokedCertificate
implements DmzX509RevokedCertificate,
Initializable {
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_ISSUER_ID = "issuer_id";
    public static final String COLUMN_SERIAL_NUMBER = "serial_number";
    public static final String ID_GEN = "x509RevokedCertificateIdGenerator";
    public static final String TABLE = "bb_x509_revoked_certificate";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="x509RevokedCertificateIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="serial_number", nullable=false)
    private final long serialNumber;
    @JoinColumn(name="issuer_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_x509_certificate_issuer"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalX509Certificate issuer;

    protected InternalX509RevokedCertificate() {
        this.id = 0L;
        this.serialNumber = 0L;
    }

    private InternalX509RevokedCertificate(Builder builder) {
        this.id = builder.id;
        this.issuer = builder.issuer;
        this.serialNumber = builder.serialNumber;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public InternalX509Certificate getIssuer() {
        return this.issuer;
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public void initialize() {
        HibernateUtils.initialize((Object)this.getIssuer());
    }

    public static class Builder {
        private long id;
        private InternalX509Certificate issuer;
        private long serialNumber;

        public Builder() {
            this.id = 0L;
        }

        public Builder(@Nonnull InternalX509RevokedCertificate certificate) {
            this.id = certificate.getId();
            this.issuer = Objects.requireNonNull(certificate.getIssuer(), "issuer");
            this.serialNumber = Objects.requireNonNull(Long.valueOf(certificate.getSerialNumber()), "serialNumber");
        }

        @Nonnull
        public InternalX509RevokedCertificate build() {
            return new InternalX509RevokedCertificate(this);
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder issuer(@Nonnull InternalX509Certificate value) {
            this.issuer = Objects.requireNonNull(value, "issuer");
            return this;
        }

        @Nonnull
        public Builder serialNumber(long value) {
            this.serialNumber = value;
            return this;
        }
    }
}

