/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.x509;

import com.atlassian.audit.api.AuditService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.x509.DmzX509CertificateService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.x509.DefaultX509CertificateService;
import com.atlassian.bitbucket.internal.x509.X509CertificateFactory;
import com.atlassian.bitbucket.internal.x509.X509CertificateRevocationListUpdateJob;
import com.atlassian.bitbucket.internal.x509.X509CertificateSignatureVerifierFactory;
import com.atlassian.bitbucket.internal.x509.X509HttpRequestExecutor;
import com.atlassian.bitbucket.internal.x509.X509RevokedCertificateHelper;
import com.atlassian.bitbucket.internal.x509.dao.HibernateX509CertificateDao;
import com.atlassian.bitbucket.internal.x509.dao.HibernateX509RevokedCertificateDao;
import com.atlassian.bitbucket.internal.x509.dao.X509CertificateDao;
import com.atlassian.bitbucket.internal.x509.dao.X509RevokedCertificateDao;
import com.atlassian.bitbucket.internal.x509.event.X509CertificateAuditingEventListener;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import java.util.concurrent.ExecutorService;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class X509Wiring {
    private static final Logger log = LoggerFactory.getLogger(X509Wiring.class);
    private static final int HTTP_DEFAULT_MAX_TIMEOUT_MS = 60000;
    private static final int HTTP_DEFAULT_MIN_TIMEOUT_MS = 2000;

    @Bean
    X509CertificateDao x509CertificateDao(SessionFactory sessionFactory) {
        return new HibernateX509CertificateDao(sessionFactory);
    }

    @Bean
    X509CertificateAuditingEventListener x509CertificateEventListener(AuditService auditService) {
        return new X509CertificateAuditingEventListener(auditService);
    }

    @Bean
    X509CertificateFactory x509CertificateFactory() {
        return new X509CertificateFactory();
    }

    @Bean
    @DefaultApplicationMode
    X509CertificateRevocationListUpdateJob x509CertificateRevocationListUpdateJob(DmzX509CertificateService certificateService, LockService lockService) {
        return new X509CertificateRevocationListUpdateJob(certificateService, lockService);
    }

    @AvailableToPlugins(value=DmzX509CertificateService.class)
    @Bean
    DmzX509CertificateService x509CertificateService(EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, X509CertificateDao x509CertificateDao, X509CertificateFactory x509CertificateFactory, X509RevokedCertificateHelper x509RevokedCertificateHelper) {
        return new DefaultX509CertificateService(eventPublisher, i18nService, permissionService, x509CertificateDao, x509CertificateFactory, x509RevokedCertificateHelper);
    }

    @Bean
    X509CertificateSignatureVerifierFactory x509CertificateSignatureVerifierFactory(FeatureManager featureManager, @Value(value="${x509.certificate.signing.certificate.matching.issuer.cache.max:25}") int signingCertMatchingIssuerCacheSize, @Value(value="${x509.certificate.signing.certificate.revoked.cache.max:250}") int signingCertRevokedCacheSize, @Value(value="${x509.certificate.signing.certificate.user.cache.max:150}") int signingCertUserCacheSize, PlatformTransactionManager transactionManager, UserService userService, X509CertificateDao x509CertificateDao, X509CertificateFactory x509CertificateFactory, X509RevokedCertificateDao x509revokedCertificateDao) {
        return new X509CertificateSignatureVerifierFactory(featureManager, signingCertRevokedCacheSize, signingCertMatchingIssuerCacheSize, signingCertUserCacheSize, transactionManager, userService, x509CertificateDao, x509CertificateFactory, x509revokedCertificateDao);
    }

    @Bean
    X509HttpRequestExecutor x509HttpRequestExecutor(HttpClientFactory httpClientFactory, @Value(value="${x509.certificate.remote.connection.timeout}") int httpConnectionTimeoutProperty, @Value(value="${x509.certificate.remote.socket.timeout}") int httpSocketTimeoutProperty) {
        int httpConnectionTimeout = httpConnectionTimeoutProperty;
        int httpSocketTimeout = httpSocketTimeoutProperty;
        if (httpConnectionTimeoutProperty < 2000 || httpConnectionTimeoutProperty > 60000) {
            log.warn("Invalid value for 'x509.certificate.remote.connection.timeout': {} must be greater than 2000and less or equal to 60000. Using default value of {} instead.", (Object)httpConnectionTimeoutProperty, (Object)60000);
            httpConnectionTimeout = 60000;
        }
        if (httpSocketTimeoutProperty < 2000 || httpSocketTimeoutProperty > 60000) {
            log.warn("Invalid value for 'x509.certificate.remote.socket.timeout': {} must be greater than 2000and less or equal to 60000. Using default value of {} instead.", (Object)httpSocketTimeoutProperty, (Object)60000);
            httpSocketTimeout = 60000;
        }
        return new X509HttpRequestExecutor(httpClientFactory, httpConnectionTimeout, httpSocketTimeout);
    }

    @Bean
    X509RevokedCertificateDao x509RevokedCertificateDao(SessionFactory sessionFactory) {
        return new HibernateX509RevokedCertificateDao(sessionFactory);
    }

    @Bean
    X509RevokedCertificateHelper x509RevokedCertificateHelper(ExecutorService executorService, LockService lockService, PlatformTransactionManager transactionManager, X509CertificateFactory x509CertificateFactory, X509HttpRequestExecutor x509HttpRequestExecutor, X509RevokedCertificateDao x509RevokedCertificateDao) {
        return new X509RevokedCertificateHelper(executorService, lockService, transactionManager, x509CertificateFactory, x509HttpRequestExecutor, x509RevokedCertificateDao);
    }
}

