/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin;

import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.internal.plugin.IssueValidationConfigurationService;
import com.atlassian.bitbucket.internal.plugin.IssueValidationConfigurationSetRequest;
import com.atlassian.bitbucket.internal.plugin.dao.InternalIssueValidationConfiguration;
import com.atlassian.bitbucket.internal.plugin.dao.IssueValidationConfigurationDao;
import com.atlassian.bitbucket.internal.plugin.event.IssueValidationConfigurationCreatedEvent;
import com.atlassian.bitbucket.internal.plugin.event.IssueValidationConfigurationDeletedEvent;
import com.atlassian.bitbucket.internal.plugin.event.IssueValidationConfigurationUpdatedEvent;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import com.atlassian.bitbucket.internal.plugin.model.SimpleIssueValidationConfiguration;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIssueValidationConfigurationService
implements IssueValidationConfigurationService {
    private final IssueValidationConfigurationDao configurationDao;
    private final EventPublisher eventPublisher;
    private final PermissionValidationService permissionValidationService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;

    @Autowired
    public DefaultIssueValidationConfigurationService(IssueValidationConfigurationDao configurationDao, EventPublisher eventPublisher, PermissionValidationService permissionValidationService, TransactionTemplate transactionTemplate, UserService userService) {
        this.configurationDao = configurationDao;
        this.eventPublisher = eventPublisher;
        this.permissionValidationService = permissionValidationService;
        this.transactionTemplate = transactionTemplate;
        this.userService = userService;
    }

    @Override
    @Nonnull
    public IssueValidationConfiguration addOrUpdateConfiguration(@Nonnull Scope scope, @Nonnull IssueValidationConfigurationSetRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateAdminPermission(scope);
        int resourceId = (Integer)scope.getResourceId().orElseThrow(() -> new IllegalStateException("All project and repository scopes should have a resource ID"));
        ScopeType scopeType = scope.getType();
        return (IssueValidationConfiguration)this.transactionTemplate.execute(() -> {
            InternalIssueValidationConfiguration existingConfig = this.configurationDao.getByScope(scope);
            if (existingConfig == null) {
                IssueValidationConfiguration newConfig = this.initialize(this.configurationDao.create(resourceId, scopeType, request), scope);
                this.eventPublisher.publish((Object)new IssueValidationConfigurationCreatedEvent(this, newConfig));
                return newConfig;
            }
            IssueValidationConfiguration initializedExistingConfig = this.initialize(existingConfig, scope);
            IssueValidationConfiguration updatedConfig = this.initialize(this.configurationDao.update(existingConfig, request), scope);
            this.eventPublisher.publish((Object)new IssueValidationConfigurationUpdatedEvent(this, updatedConfig, initializedExistingConfig));
            return updatedConfig;
        });
    }

    @Override
    public void deleteConfiguration(@Nonnull Scope scope) {
        this.validateAdminPermission(scope);
        IssueValidationConfiguration config = this.initialize(this.configurationDao.getByScope(scope), scope);
        if (config != null) {
            this.transactionTemplate.execute(() -> {
                this.configurationDao.deleteForScope((Integer)scope.getResourceId().get(), scope.getType());
                this.eventPublisher.publish((Object)new IssueValidationConfigurationDeletedEvent(this, config));
                return null;
            });
        }
    }

    @Override
    @Nonnull
    public Optional<IssueValidationConfiguration> getConfiguration(@Nonnull Scope scope) {
        this.validateReadPermission(scope);
        IssueValidationConfiguration config = (IssueValidationConfiguration)scope.accept((ScopeVisitor)new ScopeVisitor<IssueValidationConfiguration>(){

            public IssueValidationConfiguration visit(@Nonnull ProjectScope scope) {
                return DefaultIssueValidationConfigurationService.this.initialize(DefaultIssueValidationConfigurationService.this.configurationDao.getByScope((Scope)scope), (Scope)scope);
            }

            public IssueValidationConfiguration visit(@Nonnull RepositoryScope scope) {
                InternalIssueValidationConfiguration configuration = DefaultIssueValidationConfigurationService.this.configurationDao.getByScope((Scope)scope);
                if (configuration == null) {
                    ProjectScope projectScope = Scopes.project((Project)scope.getProject());
                    return DefaultIssueValidationConfigurationService.this.initialize(DefaultIssueValidationConfigurationService.this.configurationDao.getByScope((Scope)projectScope), (Scope)projectScope);
                }
                return DefaultIssueValidationConfigurationService.this.initialize(configuration, (Scope)scope);
            }
        });
        return Optional.ofNullable(config);
    }

    @EventListener
    public void onProjectDeletionRequestEvent(ProjectDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.deleteConfiguration((Scope)Scopes.project((Project)event.getProject()));
        }
    }

    @EventListener
    public void onRepositoryDeletionRequestEvent(RepositoryDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.deleteConfiguration((Scope)Scopes.repository((Repository)event.getRepository()));
        }
    }

    private IssueValidationConfiguration initialize(InternalIssueValidationConfiguration config, Scope scope) {
        if (config == null) {
            return null;
        }
        config.initialize(this.userService, scope);
        return new SimpleIssueValidationConfiguration.Builder(config.getExemptCommitMessages(), config.getExemptPushers(), config.getHookState(), config.shouldIgnoreMergeCommits(), config.getScope()).build();
    }

    private void validateAdminPermission(Scope scope) {
        Objects.requireNonNull(scope);
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultIssueValidationConfigurationService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }

            public Void visit(@Nonnull ProjectScope scope) {
                DefaultIssueValidationConfigurationService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull GlobalScope scope) {
                throw new UnsupportedOperationException("Configuration cannot be managed at a global level scope.");
            }
        });
    }

    private void validateReadPermission(Scope scope) {
        Objects.requireNonNull(scope);
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultIssueValidationConfigurationService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_READ);
                return null;
            }

            public Void visit(@Nonnull ProjectScope scope) {
                DefaultIssueValidationConfigurationService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_VIEW);
                return null;
            }

            public Void visit(@Nonnull GlobalScope scope) {
                throw new UnsupportedOperationException("Configuration cannot be managed at a global level scope.");
            }
        });
    }
}

