/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin;

import com.atlassian.bitbucket.internal.plugin.IssueValidationHookState;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class IssueValidationConfigurationSetRequest {
    private final Set<String> exemptCommitMessages;
    private final Set<ApplicationUser> exemptPushers;
    private final IssueValidationHookState hookState;
    private final boolean ignoreMergeCommits;

    public IssueValidationConfigurationSetRequest(Builder builder) {
        this.exemptCommitMessages = builder.exemptCommitMessages;
        this.exemptPushers = builder.exemptPushers;
        this.hookState = builder.hookState;
        this.ignoreMergeCommits = builder.ignoreMergeCommits;
    }

    @Nonnull
    public Set<String> getExemptCommitMessages() {
        return this.exemptCommitMessages;
    }

    @Nonnull
    public Set<ApplicationUser> getExemptPushers() {
        return this.exemptPushers;
    }

    @Nonnull
    public IssueValidationHookState getHookState() {
        return this.hookState;
    }

    public boolean shouldIgnoreMergeCommits() {
        return this.ignoreMergeCommits;
    }

    public static class Builder {
        private final IssueValidationHookState hookState;
        private Set<String> exemptCommitMessages = ImmutableSet.of();
        private Set<ApplicationUser> exemptPushers = ImmutableSet.of();
        private boolean ignoreMergeCommits;

        public Builder(@Nonnull IssueValidationHookState hookState) {
            this.hookState = Objects.requireNonNull(hookState, "hookState");
        }

        @Nonnull
        public IssueValidationConfigurationSetRequest build() {
            return new IssueValidationConfigurationSetRequest(this);
        }

        @Nonnull
        public Builder exemptCommitMessages(@Nonnull Set<String> exemptCommitMessages) {
            this.exemptCommitMessages = Objects.requireNonNull(exemptCommitMessages, "exemptCommitMessages");
            return this;
        }

        @Nonnull
        public Builder exemptPushers(@Nonnull Set<ApplicationUser> exemptPushers) {
            this.exemptPushers = Objects.requireNonNull(exemptPushers, "exemptPushers");
            return this;
        }

        @Nonnull
        public Builder ignoreMergeCommits(boolean ignoreMergeCommits) {
            this.ignoreMergeCommits = ignoreMergeCommits;
            return this;
        }
    }
}

