/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.atst;

import com.atlassian.bitbucket.internal.plugin.IssueValidationConfigurationService;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import jakarta.annotation.Nonnull;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueValidationConfigurationSupportDataHelper {
    private static final String JIRA_COMMIT_CHECKER = "bitbucket.atst.jira.commit.checker";
    private static final String EXEMPT_COMMIT_MESSAGES_COUNT = "bitbucket.atst.jira.commit.checker.exemptCommitMessages.count";
    private static final String EXEMPT_PUSHERS = "bitbucket.atst.jira.commit.checker.exemptPushers";
    private static final String EXEMPT_PUSHERS_COUNT = "bitbucket.atst.jira.commit.checker.exemptPushers.count";
    private static final String EXEMPT_PUSHERS_IDS = "bitbucket.atst.jira.commit.checker.exemptPushers.ids";
    private static final String HOOK_STATE = "bitbucket.atst.jira.commit.checker.hookState";
    private static final String IGNORE_MERGE_COMMITS = "bitbucket.atst.jira.commit.checker.ignoreMergeCommits";
    private static final String SCOPE = "bitbucket.atst.jira.commit.checker.scope";
    private final FeatureManager featureManager;
    private final IssueValidationConfigurationService service;

    @Autowired
    public IssueValidationConfigurationSupportDataHelper(FeatureManager featureManager, IssueValidationConfigurationService service) {
        this.featureManager = featureManager;
        this.service = service;
    }

    public void addConfigurationToSupportData(@Nonnull SupportDataBuilder builder, @Nonnull Scope scope) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.JIRA_COMMIT_CHECKER)) {
            return;
        }
        SupportDataBuilder jiraCommitCheckerBuilder = builder.addCategory(JIRA_COMMIT_CHECKER);
        this.service.getConfiguration(scope).ifPresent(config -> jiraCommitCheckerBuilder.addValue(HOOK_STATE, config.getHookState().toString()).addValue(EXEMPT_COMMIT_MESSAGES_COUNT, String.valueOf(config.getExemptCommitMessages().size())).addValue(SCOPE, config.getScope().getType().name()).addValue(IGNORE_MERGE_COMMITS, String.valueOf(config.shouldIgnoreMergeCommits())).addCategory(EXEMPT_PUSHERS).addValue(EXEMPT_PUSHERS_IDS, StringUtils.join((Iterable)config.getExemptPushers().stream().map(ApplicationUser::getId).collect(Collectors.toList()), (String)", ")).addValue(EXEMPT_PUSHERS_COUNT, String.valueOf(config.getExemptPushers().size())));
    }
}

