/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.internal.plugin.event.IssueValidationConfigurationCreatedEvent;
import com.atlassian.bitbucket.internal.plugin.event.IssueValidationConfigurationDeletedEvent;
import com.atlassian.bitbucket.internal.plugin.event.IssueValidationConfigurationEvent;
import com.atlassian.bitbucket.internal.plugin.event.IssueValidationConfigurationUpdatedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueValidationConfigurationEventListener {
    @VisibleForTesting
    static final String ACTION_PROJECT_ISSUE_VALIDATION_CONFIGURATION_CREATED = "bitbucket.jira.commit.checker.audit.action.project.configuration.created";
    @VisibleForTesting
    static final String ACTION_PROJECT_ISSUE_VALIDATION_CONFIGURATION_DELETED = "bitbucket.jira.commit.checker.audit.action.project.configuration.deleted";
    @VisibleForTesting
    static final String ACTION_PROJECT_ISSUE_VALIDATION_CONFIGURATION_UPDATED = "bitbucket.jira.commit.checker.audit.action.project.configuration.updated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_ISSUE_VALIDATION_CONFIGURATION_CREATED = "bitbucket.jira.commit.checker.audit.action.repository.configuration.created";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_ISSUE_VALIDATION_CONFIGURATION_DELETED = "bitbucket.jira.commit.checker.audit.action.repository.configuration.deleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_ISSUE_VALIDATION_CONFIGURATION_UPDATED = "bitbucket.jira.commit.checker.audit.action.repository.configuration.updated";
    @VisibleForTesting
    static final String ATTR_EXEMPT_COMMIT_MESSAGES = "bitbucket.jira.commit.checker.audit.attribute.configuration.exemptcommitmessages";
    @VisibleForTesting
    static final String ATTR_EXEMPT_PUSHERS = "bitbucket.jira.commit.checker.audit.attribute.configuration.exemptpushers";
    @VisibleForTesting
    static final String ATTR_HOOK_STATE = "bitbucket.jira.commit.checker.audit.attribute.configuration.hookstate";
    @VisibleForTesting
    static final String ATTR_IGNORE_MERGE_COMMITS = "bitbucket.jira.commit.checker.audit.attribute.configuration.ignoremergecommits";
    private final Map<Class<? extends IssueValidationConfigurationEvent>, ScopeVisitor<AuditEvent.Builder>> AUDIT_EVENT_SCOPE_VISITOR = ImmutableMap.of(IssueValidationConfigurationCreatedEvent.class, this.getScopeVisitor("bitbucket.jira.commit.checker.audit.action.project.configuration.created", "bitbucket.jira.commit.checker.audit.action.repository.configuration.created"), IssueValidationConfigurationDeletedEvent.class, this.getScopeVisitor("bitbucket.jira.commit.checker.audit.action.project.configuration.deleted", "bitbucket.jira.commit.checker.audit.action.repository.configuration.deleted"), IssueValidationConfigurationUpdatedEvent.class, this.getScopeVisitor("bitbucket.jira.commit.checker.audit.action.project.configuration.updated", "bitbucket.jira.commit.checker.audit.action.repository.configuration.updated"));
    private final AuditService auditService;

    @Autowired
    public IssueValidationConfigurationEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onIssueValidationConfigurationCreatedEvent(IssueValidationConfigurationCreatedEvent event) {
        this.auditIssueValidationConfigurationEvent(event);
    }

    @EventListener
    public void onIssueValidationConfigurationDeletedEvent(IssueValidationConfigurationDeletedEvent event) {
        this.auditIssueValidationConfigurationEvent(event);
    }

    @EventListener
    public void onIssueValidationConfigurationUpdatedEvent(IssueValidationConfigurationUpdatedEvent event) {
        this.auditIssueValidationConfigurationEvent(event);
    }

    private static AuditType.Builder getAuditType(String action, String category) {
        return AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)category, (String)action);
    }

    private void addChangedValues(IssueValidationConfigurationUpdatedEvent event, AuditEvent.Builder builder) {
        builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_HOOK_STATE).from(event.getOldHookState().toString()).to(event.getHookState().toString()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_EXEMPT_COMMIT_MESSAGES).from(this.exemptCommitMessagesToString(event.getOldExemptCommitMessages())).to(this.exemptCommitMessagesToString(event.getExemptCommitMessages())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_EXEMPT_PUSHERS).from(this.exemptPushersToString(event.getOldExemptPushers())).to(this.exemptPushersToString(event.getExemptPushers())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_IGNORE_MERGE_COMMITS).from(String.valueOf(event.isOldIgnoreMergeCommits())).to(String.valueOf(event.isIgnoreMergeCommits())).build());
    }

    private void addExtraAttributes(IssueValidationConfigurationEvent event, AuditEvent.Builder builder) {
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_HOOK_STATE, (String)event.getHookState().toString()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_EXEMPT_COMMIT_MESSAGES, (String)this.exemptCommitMessagesToString(event.getExemptCommitMessages())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_EXEMPT_PUSHERS, (String)this.exemptPushersToString(event.getExemptPushers())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_IGNORE_MERGE_COMMITS, (String)String.valueOf(event.isIgnoreMergeCommits())).build());
    }

    private void auditIssueValidationConfigurationEvent(IssueValidationConfigurationEvent event) {
        AuditEvent.Builder builder = (AuditEvent.Builder)event.getScope().accept(this.AUDIT_EVENT_SCOPE_VISITOR.get(((Object)((Object)event)).getClass()));
        if (event instanceof IssueValidationConfigurationUpdatedEvent) {
            this.addChangedValues((IssueValidationConfigurationUpdatedEvent)event, builder);
        } else {
            this.addExtraAttributes(event, builder);
        }
        this.auditService.audit(builder.build());
    }

    private String exemptCommitMessagesToString(Set<String> exemptCommitMessages) {
        return exemptCommitMessages.toString();
    }

    private String exemptPushersToString(Set<ApplicationUser> exemptPushers) {
        return exemptPushers.stream().map(ApplicationUser::getSlug).collect(Collectors.toList()).toString();
    }

    private ScopeVisitor<AuditEvent.Builder> getScopeVisitor(final String projectAction, final String repositoryAction) {
        return new ScopeVisitor<AuditEvent.Builder>(){

            public AuditEvent.Builder visit(@Nonnull ProjectScope projectScope) {
                return AuditEvent.builder((AuditType)IssueValidationConfigurationEventListener.getAuditType(projectAction, "bitbucket.service.audit.category.projects").build()).affectedObject(AuditUtils.auditResourceForProject((Project)projectScope.getProject()));
            }

            public AuditEvent.Builder visit(@Nonnull RepositoryScope repositoryScope) {
                return AuditEvent.builder((AuditType)IssueValidationConfigurationEventListener.getAuditType(repositoryAction, "bitbucket.service.audit.category.repositories").build()).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repositoryScope.getRepository()));
            }
        };
    }
}

