/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.plugin.IssueValidationConfigurationSetRequest;
import com.atlassian.bitbucket.internal.plugin.dao.AoIssueValidationConfiguration;
import com.atlassian.bitbucket.internal.plugin.dao.AoIssueValidationExemptCommitMessage;
import com.atlassian.bitbucket.internal.plugin.dao.AoIssueValidationExemptPusher;
import com.atlassian.bitbucket.internal.plugin.dao.InternalIssueValidationConfiguration;
import com.atlassian.bitbucket.internal.plugin.dao.IssueValidationConfigurationDao;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AoIssueValidationConfigurationDao
extends AbstractAoDao
implements IssueValidationConfigurationDao {
    private static final String FIND_BY_SCOPE_QUERY = String.format("%s = ? AND %s = ?", "RESOURCE_ID", "SCOPE_TYPE");
    private static final Logger log = LoggerFactory.getLogger(AoIssueValidationConfigurationDao.class);

    @Autowired
    public AoIssueValidationConfigurationDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public InternalIssueValidationConfiguration create(int resourceId, @Nonnull ScopeType scopeType, @Nonnull IssueValidationConfigurationSetRequest request) {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"HOOK_STATE", (Object)request.getHookState()).put((Object)"RESOURCE_ID", (Object)resourceId).put((Object)"SCOPE_TYPE", (Object)scopeType).put((Object)"IGNORE_MERGE_COMMITS", (Object)request.shouldIgnoreMergeCommits()).build();
        AoIssueValidationConfiguration config = (AoIssueValidationConfiguration)this.ao.create(AoIssueValidationConfiguration.class, (Map)properties);
        this.addExemptPushers(request.getExemptPushers(), config);
        this.addExemptCommitMessages(request.getExemptCommitMessages(), config);
        return (InternalIssueValidationConfiguration)this.ao.get(AoIssueValidationConfiguration.class, (Object)config.getId());
    }

    @Override
    public void deleteForScope(int resourceId, @Nonnull ScopeType scopeType) {
        Arrays.stream((AoIssueValidationConfiguration[])this.ao.find(AoIssueValidationConfiguration.class, FIND_BY_SCOPE_QUERY, new Object[]{resourceId, scopeType})).forEach(this::delete);
    }

    @Override
    @Nullable
    public InternalIssueValidationConfiguration getByScope(@Nonnull Scope scope) {
        AoIssueValidationConfiguration[] configs = (AoIssueValidationConfiguration[])this.ao.find(AoIssueValidationConfiguration.class, FIND_BY_SCOPE_QUERY, new Object[]{scope.getResourceId().get(), scope.getType()});
        if (configs.length > 1) {
            log.warn("Multiple issue validation configs found for scope: {}", (Object)scope);
        }
        return configs.length == 0 ? null : configs[0];
    }

    @Override
    @Nonnull
    public InternalIssueValidationConfiguration update(@Nonnull InternalIssueValidationConfiguration existingConfig, @Nonnull IssueValidationConfigurationSetRequest request) {
        this.deleteExemptCommitMessages(existingConfig.getId());
        this.deleteExemptPushers(existingConfig.getId());
        AoIssueValidationConfiguration aoExistingConfig = (AoIssueValidationConfiguration)existingConfig;
        aoExistingConfig.setHookState(request.getHookState());
        aoExistingConfig.setIgnoreMergeCommits(request.shouldIgnoreMergeCommits());
        this.addExemptCommitMessages(request.getExemptCommitMessages(), aoExistingConfig);
        this.addExemptPushers(request.getExemptPushers(), aoExistingConfig);
        aoExistingConfig.save();
        return (InternalIssueValidationConfiguration)this.ao.get(AoIssueValidationConfiguration.class, (Object)aoExistingConfig.getId());
    }

    private void addExemptCommitMessages(Set<String> exemptCommitMessages, AoIssueValidationConfiguration config) {
        exemptCommitMessages.forEach(commitMessage -> {
            AoIssueValidationExemptCommitMessage exemptCommitMessage = (AoIssueValidationExemptCommitMessage)this.ao.create(AoIssueValidationExemptCommitMessage.class, (Map)ImmutableMap.builder().put((Object)"EXEMPTION", commitMessage).put((Object)"FK_CONFIGURATION_ID", (Object)config.getId()).build());
            exemptCommitMessage.setConfiguration(config);
        });
    }

    private void addExemptPushers(Set<ApplicationUser> exemptPushers, AoIssueValidationConfiguration config) {
        exemptPushers.forEach(pusher -> {
            AoIssueValidationExemptPusher exemptPusher = (AoIssueValidationExemptPusher)this.ao.create(AoIssueValidationExemptPusher.class, (Map)ImmutableMap.builder().put((Object)"USER_ID", (Object)pusher.getId()).put((Object)"FK_CONFIGURATION_ID", (Object)config.getId()).build());
            exemptPusher.setConfiguration(config);
        });
    }

    private void delete(AoIssueValidationConfiguration config) {
        this.deleteExemptPushers(config.getId());
        this.deleteExemptCommitMessages(config.getId());
        this.ao.delete(new RawEntity[]{config});
    }

    private void deleteExemptCommitMessages(long configId) {
        this.ao.deleteWithSQL(AoIssueValidationExemptCommitMessage.class, "FK_CONFIGURATION_ID = ?", new Object[]{configId});
    }

    private void deleteExemptPushers(long configId) {
        this.ao.deleteWithSQL(AoIssueValidationExemptPusher.class, "FK_CONFIGURATION_ID = ?", new Object[]{configId});
    }
}

