/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.dao;

import com.atlassian.bitbucket.internal.plugin.dao.AoIssueValidationConfiguration;
import com.atlassian.bitbucket.internal.plugin.dao.AoIssueValidationExemptCommitMessage;
import com.atlassian.bitbucket.internal.plugin.dao.AoIssueValidationExemptPusher;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class PartialIssueValidationConfiguration {
    private final AoIssueValidationConfiguration delegate;
    private Set<String> exemptCommitMessages;
    private Set<ApplicationUser> exemptPushers;
    private Scope scope;

    public PartialIssueValidationConfiguration(AoIssueValidationConfiguration delegate) {
        this.delegate = delegate;
    }

    @Nonnull
    public Set<String> getExemptCommitMessages() {
        return this.exemptCommitMessages;
    }

    @Nonnull
    public Set<ApplicationUser> getExemptPushers() {
        return this.exemptPushers;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    public void initialize(@Nonnull UserService userService, @Nonnull Scope scope) {
        this.scope = scope;
        this.exemptPushers = Arrays.stream(this.delegate.getAoExemptPushers()).sorted(Comparator.comparingLong(AoIssueValidationExemptPusher::getId)).map(pusher -> userService.getUserById(pusher.getUserId().intValue(), true)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.exemptCommitMessages = Arrays.stream(this.delegate.getAoExemptCommitMessages()).sorted(Comparator.comparingLong(AoIssueValidationExemptCommitMessage::getId)).map(AoIssueValidationExemptCommitMessage::getCommitMessageExemption).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

