/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.event;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.internal.plugin.IssueValidationHookState;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

@TransactionAware
public class IssueValidationConfigurationEvent
extends ApplicationEvent {
    private final IssueValidationConfiguration configuration;

    protected IssueValidationConfigurationEvent(@Nonnull Object source, @Nonnull IssueValidationConfiguration configuration) {
        super(source);
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    @Nonnull
    public Set<String> getExemptCommitMessages() {
        return this.configuration.getExemptCommitMessages();
    }

    @Nonnull
    public Set<ApplicationUser> getExemptPushers() {
        return this.configuration.getExemptPushers();
    }

    @Nonnull
    public IssueValidationHookState getHookState() {
        return this.configuration.getHookState();
    }

    @Nonnull
    public Scope getScope() {
        return this.configuration.getScope();
    }

    public boolean isIgnoreMergeCommits() {
        return this.configuration.shouldIgnoreMergeCommits();
    }
}

