/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.internal.plugin.IssueValidationHookState;
import com.atlassian.bitbucket.internal.plugin.event.IssueValidationConfigurationEvent;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

@AsynchronousPreferred
@EventName(value="stash.jira.commit.checker.configuration.updated")
public class IssueValidationConfigurationUpdatedEvent
extends IssueValidationConfigurationEvent {
    private final IssueValidationConfiguration oldConfiguration;

    public IssueValidationConfigurationUpdatedEvent(@Nonnull Object source, @Nonnull IssueValidationConfiguration configuration, @Nonnull IssueValidationConfiguration oldConfiguration) {
        super(source, configuration);
        this.oldConfiguration = Objects.requireNonNull(oldConfiguration, "oldConfiguration");
    }

    @Nonnull
    public Set<String> getOldExemptCommitMessages() {
        return this.oldConfiguration.getExemptCommitMessages();
    }

    @Nonnull
    public Set<ApplicationUser> getOldExemptPushers() {
        return this.oldConfiguration.getExemptPushers();
    }

    @Nonnull
    public IssueValidationHookState getOldHookState() {
        return this.oldConfiguration.getHookState();
    }

    public boolean isOldIgnoreMergeCommits() {
        return this.oldConfiguration.shouldIgnoreMergeCommits();
    }
}

