/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.hooks.jira;

import com.atlassian.bitbucket.dmz.resilience.CircuitBreakerConfiguration;
import com.atlassian.bitbucket.dmz.resilience.CircuitBreakerService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.integration.jira.JiraAuthenticationRequiredException;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CircuitBreakerHelper {
    private static final Logger log = LoggerFactory.getLogger(CircuitBreakerHelper.class);
    private static final String CIRCUIT_BREAKER_CONFIG_NAME = "jira-commit-checker";
    private static final boolean DEFAULT_ENABLED = true;
    private static final int DEFAULT_FAILURE_THRESHOLD = 50;
    private static final int DEFAULT_MINIMUM_CALLS_REQUIRED = 50;
    private static final int DEFAULT_NUM_CALLS_IN_HALF_OPEN = 10;
    private static final long DEFAULT_SLOW_CALL_THRESHOLD = 2L;
    private static final long DEFAULT_WAIT_IN_OPEN_STATE = 60L;
    private static final String ENABLED = "plugin.jira-commit-checker.circuitbreaker.default.enabled";
    private static final String FAILURE_THRESHOLD = "plugin.jira-commit-checker.circuitbreaker.default.failurethreshold";
    private static final String NUM_CALLS_IN_HALF_OPEN = "plugin.jira-commit-checker.circuitbreaker.default.callsinhalfopen";
    private static final String SLOW_CALL_THRESHOLD = "plugin.jira-commit-checker.circuitbreaker.default.slowcallthreshold";
    private static final String WAIT_IN_OPEN_STATE = "plugin.jira-commit-checker.circuitbreaker.default.waitinopenstate";
    private final CircuitBreakerService circuitBreakerService;

    @Autowired
    public CircuitBreakerHelper(CircuitBreakerService circuitBreakerService, ApplicationPropertiesService propertiesService) {
        this.circuitBreakerService = circuitBreakerService;
        if (circuitBreakerService.getConfiguration(CIRCUIT_BREAKER_CONFIG_NAME).isPresent()) {
            log.info("Circuitbreaker config already present, likely a restart of plugin, continue with existing config");
        } else {
            circuitBreakerService.addConfiguration(new CircuitBreakerConfiguration.Builder(CIRCUIT_BREAKER_CONFIG_NAME).minimumCallsRequired(50).numberOfCallsInHalfOpen(propertiesService.getPluginProperty(NUM_CALLS_IN_HALF_OPEN, 10)).failureThreshold((float)propertiesService.getPluginProperty(FAILURE_THRESHOLD, 50)).setEnabled(propertiesService.getPluginProperty(ENABLED, true)).slowCallThreshold(Duration.ofSeconds(propertiesService.getPluginProperty(SLOW_CALL_THRESHOLD, 2L))).waitInOpenState(Duration.ofSeconds(propertiesService.getPluginProperty(WAIT_IN_OPEN_STATE, 60L))).writeStackTraces(false).exceptionsToIgnore(t -> t instanceof JiraAuthenticationRequiredException).build());
        }
    }

    public Callable<Set<String>> decorate(@Nonnull String applicationId, @Nonnull Callable<Set<String>> callable) {
        Objects.requireNonNull(applicationId, "applicationId");
        Objects.requireNonNull(callable, "callable");
        return this.circuitBreakerService.decorateWithCircuitBreaker(applicationId, CIRCUIT_BREAKER_CONFIG_NAME, callable);
    }
}

