/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.hooks.jira;

import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.internal.plugin.IssueValidationHookState;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.ErrorMessageHelper;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.JiraValidationHelper;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import com.atlassian.integration.jira.JiraKeyScanner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CommitMessageValidationHelper {
    private static final int MAX_COMMIT_MESSAGE_LENGTH = 128;
    private static final int MAX_COMMIT_SCANNING_ERRORS_TO_PRINT = 50;
    private final List<String> commitScanningErrors;
    private final IssueValidationConfiguration configuration;
    private final ErrorMessageHelper errorMessageHelper;
    private final Set<String> ignoredProjectKeys;
    private final Set<String> issueKeysToCheck;
    private final JiraValidationHelper jiraValidationHelper;
    private final JiraKeyScanner keyScanner;
    private int sizeOfCommitScanningErrors;

    public CommitMessageValidationHelper(IssueValidationConfiguration configuration, ErrorMessageHelper errorMessageHelper, Set<String> ignoredProjectKeys, JiraValidationHelper jiraValidationHelper, JiraKeyScanner keyScanner) {
        this.configuration = configuration;
        this.errorMessageHelper = errorMessageHelper;
        this.ignoredProjectKeys = ignoredProjectKeys;
        this.jiraValidationHelper = jiraValidationHelper;
        this.keyScanner = keyScanner;
        this.commitScanningErrors = Lists.newArrayList();
        this.sizeOfCommitScanningErrors = 0;
        this.issueKeysToCheck = Sets.newHashSet();
    }

    @Nonnull
    public RepositoryHookResult getResult() {
        if (!this.commitScanningErrors.isEmpty()) {
            return this.errorMessageHelper.formatAndReturnHookRejectedResult(this.errorMessageHelper.printCommitScanningErrors(this.commitScanningErrors, this.sizeOfCommitScanningErrors));
        }
        if (this.configuration.getHookState() == IssueValidationHookState.REGEX_MATCHING) {
            return RepositoryHookResult.accepted();
        }
        return this.jiraValidationHelper.performJiraValidationWithTimeout(this.issueKeysToCheck);
    }

    public void performCommitMessageScanning(@Nullable String commitMessage, @Nonnull String displayId) {
        Objects.requireNonNull(displayId, "displayId");
        if (commitMessage == null) {
            this.addToCommitScanningErrors(displayId, "");
            return;
        }
        if (this.skipCommitMessage(commitMessage)) {
            return;
        }
        Set<String> foundKeys = this.removeIgnoredKeys(this.keyScanner.findAll((CharSequence)commitMessage));
        if (foundKeys.isEmpty()) {
            this.addToCommitScanningErrors(displayId, commitMessage);
            return;
        }
        this.issueKeysToCheck.addAll(foundKeys);
    }

    private static String getProjectPart(String key) {
        return key.substring(0, key.indexOf(45));
    }

    private static String removeNewLines(String commitMessage) {
        return StringUtils.replace((String)commitMessage, (String)"\n", (String)" ");
    }

    private static String truncateCommitMessage(String commitMessage) {
        String truncatedCommitMessage = StringUtils.truncate((String)commitMessage, (int)128);
        if (commitMessage.length() > 128) {
            return truncatedCommitMessage + "...";
        }
        return truncatedCommitMessage;
    }

    private void addToCommitScanningErrors(String displayId, String commitMessage) {
        if (this.sizeOfCommitScanningErrors < 50) {
            this.commitScanningErrors.add(displayId + " " + CommitMessageValidationHelper.removeNewLines(CommitMessageValidationHelper.truncateCommitMessage(commitMessage)));
        }
        ++this.sizeOfCommitScanningErrors;
    }

    private Set<String> removeIgnoredKeys(Iterable<String> foundKeys) {
        HashSet keys = Sets.newHashSet(foundKeys);
        keys.removeIf(key -> this.ignoredProjectKeys.contains(CommitMessageValidationHelper.getProjectPart(key)));
        return keys;
    }

    private boolean skipCommitMessage(String message) {
        return this.configuration.getExemptCommitMessages().stream().anyMatch(message::contains);
    }
}

