/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.hooks.jira;

import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.i18n.I18nService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class ErrorMessageHelper {
    private static final int MAX_ISSUE_KEYS_TO_PRINT = 100;
    protected final I18nService i18nService;

    public ErrorMessageHelper(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public abstract RepositoryHookResult formatAndReturnHookRejectedResult(String var1);

    public abstract String printAuthenticationRequiredMessage(@Nonnull String var1);

    public String printCommitScanningErrors(@Nonnull List<String> commitScanningErrors, int sizeOfCommitScanningErrors) {
        Objects.requireNonNull(commitScanningErrors, "commitScanningErrors");
        int remainingElements = sizeOfCommitScanningErrors - commitScanningErrors.size();
        String commitScanningErrorsString = StringUtils.join(commitScanningErrors, (String)"\n");
        String errors = String.format("%s\n%s", this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.nojirakeys", new Object[0]), commitScanningErrorsString);
        if (remainingElements > 0) {
            return String.format("%s\n...%s", errors, this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.more.commits", new Object[]{remainingElements}));
        }
        return errors;
    }

    public String printIssueKeysToCheck(@Nonnull Set<String> issueKeys) {
        Objects.requireNonNull(issueKeys, "issueKeys");
        int remainingElements = issueKeys.size() - 100;
        String issueKeysString = StringUtils.join((Iterable)Iterables.limit(issueKeys, (int)100), (String)", ");
        String errors = String.format("%s\n%s", this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.novalidissues", new Object[0]), issueKeysString);
        if (remainingElements > 0) {
            return String.format("%s...%s", errors, this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.more.issues", new Object[]{remainingElements}));
        }
        return errors;
    }

    public abstract String printTimeoutMessage();

    public abstract String printValidationErrors(@Nonnull List<String> var1, @Nonnull Set<String> var2);

    @VisibleForTesting
    String printHookRejectedSummary() {
        return this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.rejected.summary", new Object[0]);
    }
}

