/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.hooks.jira;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.plugin.IssueValidationConfigurationService;
import com.atlassian.bitbucket.internal.plugin.IssueValidationHookState;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.CircuitBreakerHelper;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.CommitMessageValidationHelper;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.ErrorMessageHelper;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.IssueCacheKey;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.JiraValidationHelper;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.MultiCommitErrorMessageHelper;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.MultiCommitMessageValidator;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.SingleCommitErrorMessageHelper;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.SingleCommitMessageValidator;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.integration.jira.JiraKeyScanner;
import com.atlassian.integration.jira.JiraService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueValidationHook
implements PreRepositoryHook<RepositoryHookRequest> {
    private static final String DEFAULT_IGNORED_PROJECT_KEYS = "UTC,GMT,ISO,SHA,AES,UTF,RFC";
    private static final long DEFAULT_JIRA_VALIDATION_TIMEOUT = 5L;
    private static final int DEFAULT_MAX_ENTRIES = 10000;
    private static final long DEFAULT_TTL = 360L;
    private static final String IGNORED_PROJECT_KEYS = "plugin.jira-commit-checker.project.key.ignore";
    private static final Pattern IGNORED_PROJECT_KEY_PATTERN = Pattern.compile("^[A-Z]+$");
    private static final String ISSUE_CACHE_ENABLED = "plugin.jira-commit-checker.issue-key-cache.enabled";
    private static final String ISSUE_CACHE_MAX_ENTRIES = "plugin.jira-commit-checker.issue-key-cache.max";
    private static final String ISSUE_CACHE_TTL = "plugin.jira-commit-checker.issue-key-cache.expiry";
    private static final String JIRA_VALIDATION_TIMEOUT = "plugin.jira-commit-checker.jira-validation.timeout";
    private static final Set<String> PERMITTED_STRATEGIES = ImmutableSet.of((Object)"squash", (Object)"squash-ff-only");
    private static final String VALIDATE_ON_MERGE = "plugin.jira-commit-checker.validate.on.merge";
    private static final Logger log = LoggerFactory.getLogger(IssueValidationHook.class);
    private final ApplicationLinkService applicationLinkService;
    private final AuthenticationContext authenticationContext;
    private final CircuitBreakerHelper circuitBreakerHelper;
    private final IssueValidationConfigurationService configurationService;
    private final ExecutorService executorService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final Set<String> ignoredProjectKeys;
    private final Cache<IssueCacheKey, Boolean> issueCache;
    private final JiraService jiraService;
    private final long jiraValidationTimeout;
    private final JiraKeyScanner keyScanner;
    private final Set<RepositoryHookTrigger> permittedTriggers;
    private final ApplicationPropertiesService propertiesService;

    public IssueValidationHook(ApplicationLinkService applicationLinkService, AuthenticationContext authenticationContext, CircuitBreakerHelper circuitBreakerHelper, IssueValidationConfigurationService configurationService, ExecutorService executorService, FeatureManager featureManager, CacheFactory cacheFactory, I18nService i18nService, JiraService jiraService, JiraKeyScanner keyScanner, ApplicationPropertiesService propertiesService) {
        this.applicationLinkService = applicationLinkService;
        this.authenticationContext = authenticationContext;
        this.circuitBreakerHelper = circuitBreakerHelper;
        this.configurationService = configurationService;
        this.executorService = executorService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.jiraService = jiraService;
        this.keyScanner = keyScanner;
        this.propertiesService = propertiesService;
        this.jiraValidationTimeout = propertiesService.getPluginProperty(JIRA_VALIDATION_TIMEOUT, 5L);
        this.ignoredProjectKeys = IssueValidationHook.getIgnoredProjectKeys(propertiesService.getPluginProperty(IGNORED_PROJECT_KEYS, DEFAULT_IGNORED_PROJECT_KEYS));
        this.permittedTriggers = propertiesService.getPluginProperty(VALIDATE_ON_MERGE, true) ? ImmutableSet.of((Object)StandardRepositoryHookTrigger.REPO_PUSH, (Object)StandardRepositoryHookTrigger.FILE_EDIT, (Object)StandardRepositoryHookTrigger.PULL_REQUEST_MERGE) : ImmutableSet.of((Object)StandardRepositoryHookTrigger.REPO_PUSH, (Object)StandardRepositoryHookTrigger.FILE_EDIT);
        this.issueCache = this.setupCache(cacheFactory);
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryHookRequest request) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.JIRA_COMMIT_CHECKER)) {
            return RepositoryHookResult.accepted();
        }
        if (this.permittedTriggers.contains(request.getTrigger())) {
            if (request.getTrigger() == StandardRepositoryHookTrigger.PULL_REQUEST_MERGE && request.isDryRun()) {
                return RepositoryHookResult.accepted();
            }
            Repository repository = request.getRepository();
            Optional<IssueValidationConfiguration> optionalConfig = this.configurationService.getConfiguration((Scope)Scopes.repository((Repository)repository)).filter(this::shouldValidate);
            if (!optionalConfig.isPresent()) {
                return RepositoryHookResult.accepted();
            }
            IssueValidationConfiguration configuration = optionalConfig.get();
            ErrorMessageHelper errorMessageHelper = this.createErrorMessageHelper(request.getTrigger());
            JiraValidationHelper jiraValidationHelper = this.createJiraValidationHelper(errorMessageHelper, repository);
            CommitMessageValidationHelper commitMessageValidationHelper = this.createCommitMessageValidationHelper(configuration, errorMessageHelper, jiraValidationHelper);
            if (request instanceof PullRequestMergeHookRequest) {
                PullRequestMergeHookRequest mergeRequest = (PullRequestMergeHookRequest)request;
                if (IssueValidationHook.isSquashMerge(mergeRequest) || !configuration.shouldIgnoreMergeCommits()) {
                    return IssueValidationHook.validateMergeCommit(mergeRequest, commitMessageValidationHelper);
                }
            } else {
                MultiCommitMessageValidator multiCommitMessageValidator = IssueValidationHook.createMultiCommitMessageValidator(commitMessageValidationHelper, configuration);
                context.registerCommitCallback((PreRepositoryHookCommitCallback)multiCommitMessageValidator, RepositoryHookCommitFilter.ADDED_TO_REPOSITORY, new RepositoryHookCommitFilter[0]);
            }
        }
        return RepositoryHookResult.accepted();
    }

    @VisibleForTesting
    static Set<String> getIgnoredProjectKeys(String ignoredProjectKeys) {
        ArrayList invalidKeys = Lists.newArrayList();
        Set<String> keys = Arrays.stream(StringUtils.split((String)ignoredProjectKeys, (String)",")).filter(key -> {
            if (!IGNORED_PROJECT_KEY_PATTERN.matcher((CharSequence)key).matches()) {
                invalidKeys.add(key);
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
        if (!invalidKeys.isEmpty()) {
            log.warn("The following are invalid project keys: {}. Please update property {}", (Object)invalidKeys, (Object)IGNORED_PROJECT_KEYS);
        }
        return keys;
    }

    private static MultiCommitMessageValidator createMultiCommitMessageValidator(CommitMessageValidationHelper helper, IssueValidationConfiguration configuration) {
        return new MultiCommitMessageValidator(helper, configuration);
    }

    private static boolean isSquashMerge(PullRequestMergeHookRequest request) {
        return request.getStrategyId().map(PERMITTED_STRATEGIES::contains).orElse(false);
    }

    private static RepositoryHookResult validateMergeCommit(PullRequestMergeHookRequest request, CommitMessageValidationHelper commitMessageValidationHelper) {
        String commitMessage = request.getMessage().orElse(null);
        String displayId = StringUtils.substring((String)request.getMergeHash().orElse(""), (int)0, (int)11);
        SingleCommitMessageValidator validator = new SingleCommitMessageValidator(commitMessageValidationHelper);
        return validator.validateCommitMessage(commitMessage, displayId);
    }

    private CommitMessageValidationHelper createCommitMessageValidationHelper(IssueValidationConfiguration config, ErrorMessageHelper errorMessageHelper, JiraValidationHelper jiraValidationHelper) {
        return new CommitMessageValidationHelper(config, errorMessageHelper, this.ignoredProjectKeys, jiraValidationHelper, this.keyScanner);
    }

    private ErrorMessageHelper createErrorMessageHelper(RepositoryHookTrigger trigger) {
        if (trigger == StandardRepositoryHookTrigger.PULL_REQUEST_MERGE) {
            return new SingleCommitErrorMessageHelper(this.i18nService);
        }
        return new MultiCommitErrorMessageHelper(this.i18nService, this.propertiesService.getBaseUrl());
    }

    private JiraValidationHelper createJiraValidationHelper(ErrorMessageHelper errorMessageHelper, Repository repository) {
        return new JiraValidationHelper(this.applicationLinkService, this.authenticationContext.getCurrentUser(), this.circuitBreakerHelper, errorMessageHelper, this.executorService, this.i18nService, this.issueCache, this.jiraService, this.jiraValidationTimeout, repository);
    }

    private Cache<IssueCacheKey, Boolean> setupCache(CacheFactory cacheFactory) {
        CacheSettingsBuilder builder = new CacheSettingsBuilder().local();
        if (this.propertiesService.getPluginProperty(ISSUE_CACHE_ENABLED, true)) {
            builder.expireAfterWrite(this.propertiesService.getPluginProperty(ISSUE_CACHE_TTL, 360L), TimeUnit.MINUTES).maxEntries(this.propertiesService.getPluginProperty(ISSUE_CACHE_MAX_ENTRIES, 10000));
        } else {
            builder.expireAfterWrite(0L, TimeUnit.SECONDS).maxEntries(1);
        }
        return cacheFactory.getCache(this.getClass().getName() + ".issueCache", null, builder.build());
    }

    private boolean shouldValidate(IssueValidationConfiguration config) {
        return config.getHookState() != IssueValidationHookState.OFF && !config.getExemptPushers().contains(this.authenticationContext.getCurrentUser());
    }
}

