/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.hooks.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.bitbucket.dmz.resilience.CallNotAllowedException;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.CircuitBreakerHelper;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.ErrorMessageHelper;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.IssueCacheKey;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.cache.Cache;
import com.atlassian.integration.jira.JiraAuthenticationRequiredException;
import com.atlassian.integration.jira.JiraCommunicationException;
import com.atlassian.integration.jira.JiraService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraValidationHelper {
    private static final Logger log = LoggerFactory.getLogger(JiraValidationHelper.class);
    private final ApplicationLinkService applicationLinkService;
    private final ApplicationUser applicationUser;
    private final CircuitBreakerHelper circuitBreakerHelper;
    private final ErrorMessageHelper errorMessageHelper;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final Cache<IssueCacheKey, Boolean> issueCache;
    private final JiraService jiraService;
    private final long jiraValidationTimeout;
    private final Repository repository;
    private final List<String> validationErrors;
    private Set<String> issueKeysToCheck;

    public JiraValidationHelper(ApplicationLinkService applicationLinkService, ApplicationUser applicationUser, CircuitBreakerHelper circuitBreakerHelper, ErrorMessageHelper errorMessageHelper, ExecutorService executorService, I18nService i18nService, Cache<IssueCacheKey, Boolean> issueCache, JiraService jiraService, long jiraValidationTimeout, Repository repository) {
        this.applicationLinkService = applicationLinkService;
        this.applicationUser = applicationUser;
        this.circuitBreakerHelper = circuitBreakerHelper;
        this.errorMessageHelper = errorMessageHelper;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.issueCache = issueCache;
        this.jiraService = jiraService;
        this.jiraValidationTimeout = jiraValidationTimeout;
        this.repository = repository;
        this.validationErrors = Lists.newArrayList();
    }

    @Nonnull
    public RepositoryHookResult performJiraValidationWithTimeout(Set<String> issueKeysToCheck) {
        this.setIssueKeysToCheck(issueKeysToCheck);
        Future<RepositoryHookResult> future = this.executorService.submit(this::performJiraValidation);
        try {
            return future.get(this.jiraValidationTimeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.debug("Thread timed out during jira validation");
            future.cancel(true);
            return this.errorMessageHelper.formatAndReturnHookRejectedResult(this.errorMessageHelper.printTimeoutMessage());
        }
        catch (InterruptedException e) {
            log.debug("Thread interrupted during jira validation", e.getCause());
            Thread.currentThread().interrupt();
            future.cancel(true);
            return this.errorMessageHelper.formatAndReturnHookRejectedResult(this.errorMessageHelper.printTimeoutMessage());
        }
        catch (ExecutionException e) {
            future.cancel(true);
            log.debug("Jira validation failed", e.getCause());
            return this.errorMessageHelper.formatAndReturnHookRejectedResult(this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.validationfailed", new Object[0]));
        }
    }

    @VisibleForTesting
    RepositoryHookResult performJiraValidation() {
        List<ApplicationLink> jiraLinks = this.getJiraApplicationLinks();
        if (jiraLinks.isEmpty()) {
            return this.errorMessageHelper.formatAndReturnHookRejectedResult(this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.nojirainstances", new Object[0]));
        }
        this.searchKeysInCacheAndRemoveFromCheck();
        if (this.issueKeysToCheck.isEmpty()) {
            return RepositoryHookResult.accepted();
        }
        for (ApplicationLink applicationLink : jiraLinks) {
            this.findValidKeysInJiraAndRemoveFromCheck(applicationLink);
            if (!this.issueKeysToCheck.isEmpty()) continue;
            return RepositoryHookResult.accepted();
        }
        if (!this.validationErrors.isEmpty()) {
            return this.errorMessageHelper.formatAndReturnHookRejectedResult(this.errorMessageHelper.printValidationErrors(this.validationErrors, this.issueKeysToCheck));
        }
        return this.errorMessageHelper.formatAndReturnHookRejectedResult(this.errorMessageHelper.printIssueKeysToCheck(this.issueKeysToCheck));
    }

    @VisibleForTesting
    void setIssueKeysToCheck(Set<String> issueKeysToCheck) {
        this.issueKeysToCheck = Sets.newHashSet(issueKeysToCheck);
    }

    private void addKeysToCache(Set<String> issueKeys) {
        int userId = this.applicationUser.getId();
        issueKeys.forEach(issue -> this.issueCache.put((Object)new IssueCacheKey((String)issue, userId), (Object)true));
        log.debug("Issue keys added to cache: {}", (Object)StringUtils.join(issueKeys, (String)", "));
    }

    private void findValidKeysInJiraAndRemoveFromCheck(ApplicationLink applicationLink) {
        try {
            Set<String> validIssues = this.wrapJiraCall(applicationLink).call();
            this.addKeysToCache(validIssues);
            this.issueKeysToCheck.removeAll(validIssues);
        }
        catch (JiraAuthenticationRequiredException e) {
            this.validationErrors.add(this.errorMessageHelper.printAuthenticationRequiredMessage(applicationLink.getName()));
        }
        catch (JiraCommunicationException e) {
            this.validationErrors.add(this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.communicationerror", new Object[]{applicationLink.getName()}));
        }
        catch (NoSuchElementException e) {
            this.validationErrors.add(this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.invalidjiralink", new Object[]{applicationLink.getName()}));
        }
        catch (CallNotAllowedException e) {
            this.validationErrors.add(this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.circuitbreakeropen", new Object[]{applicationLink.getName()}));
        }
        catch (Exception e) {
            this.validationErrors.add(this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.unexpectederror", new Object[]{applicationLink.getName()}));
        }
    }

    private List<ApplicationLink> getJiraApplicationLinks() {
        LinkedHashSet jiraLinks = new LinkedHashSet(this.jiraService.getJiraLinksForEntity(this.repository.getProject().getKey()));
        Iterables.addAll(jiraLinks, (Iterable)this.applicationLinkService.getApplicationLinks(JiraApplicationType.class));
        return ImmutableList.copyOf(jiraLinks);
    }

    private void searchKeysInCacheAndRemoveFromCheck() {
        HashSet foundIssueKeys = Sets.newHashSet();
        this.issueKeysToCheck.removeIf(issue -> {
            if (this.issueCache.containsKey((Object)new IssueCacheKey((String)issue, this.applicationUser.getId()))) {
                foundIssueKeys.add(issue);
                return true;
            }
            return false;
        });
        log.debug("Found issue keys in cache: {}", (Object)StringUtils.join((Iterable)foundIssueKeys, (String)", "));
    }

    private Callable<Set<String>> wrapJiraCall(ApplicationLink applicationLink) {
        ApplicationId applicationId = applicationLink.getId();
        return this.circuitBreakerHelper.decorate(applicationId.get(), () -> this.jiraService.findValidIssues(this.issueKeysToCheck, applicationId));
    }
}

