/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.hooks.jira;

import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.ErrorMessageHelper;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MultiCommitErrorMessageHelper
extends ErrorMessageHelper {
    private static final String AUTHENTICATION_URL = "/plugins/servlet/oauth/users/access-tokens?tab=outgoing-authorizations";
    private final URI baseUrl;

    public MultiCommitErrorMessageHelper(I18nService i18nService, URI baseUrl) {
        super(i18nService);
        this.baseUrl = baseUrl;
    }

    @Override
    public RepositoryHookResult formatAndReturnHookRejectedResult(String detailMessage) {
        return RepositoryHookResult.rejected((String)String.format("\n%s", this.printHookRejectedSummary()), (String)String.format("%s\n", detailMessage));
    }

    @Override
    public String printAuthenticationRequiredMessage(@Nonnull String applinkName) {
        Objects.requireNonNull(applinkName, "applinkName");
        String authenticationError = this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.notauthenticated", new Object[]{applinkName});
        if (this.baseUrl != null) {
            String authorizedApplicationsUrl = URI.create(this.baseUrl.toASCIIString() + AUTHENTICATION_URL).toString();
            return String.format("%s\n    %s", authenticationError, authorizedApplicationsUrl);
        }
        return authenticationError;
    }

    @Override
    public String printTimeoutMessage() {
        return this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.timeout", new Object[0]);
    }

    @Override
    public String printValidationErrors(@Nonnull List<String> validationErrors, @Nonnull Set<String> issueKeysToCheck) {
        Objects.requireNonNull(validationErrors, "validationErrors");
        Objects.requireNonNull(issueKeysToCheck, "issueKeysToCheck");
        validationErrors.add("\n" + this.printIssueKeysToCheck(issueKeysToCheck));
        return String.format("%s\n%s", this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.validationerrors", new Object[0]), StringUtils.join(validationErrors, (char)'\n'));
    }
}

