/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.hooks.jira;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.hook.repository.CommitAddedDetails;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.CommitMessageValidationHelper;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class MultiCommitMessageValidator
implements PreRepositoryHookCommitCallback {
    private final CommitMessageValidationHelper commitMessageValidationHelper;
    private final IssueValidationConfiguration configuration;

    public MultiCommitMessageValidator(CommitMessageValidationHelper commitMessageValidationHelper, IssueValidationConfiguration configuration) {
        this.commitMessageValidationHelper = commitMessageValidationHelper;
        this.configuration = configuration;
    }

    @Nonnull
    public RepositoryHookResult getResult() {
        return this.commitMessageValidationHelper.getResult();
    }

    public boolean onCommitAdded(@Nonnull CommitAddedDetails commitDetails) {
        Objects.requireNonNull(commitDetails, "commitDetails");
        Commit commit = commitDetails.getCommit();
        if (this.configuration.shouldIgnoreMergeCommits() && MultiCommitMessageValidator.isMergeCommit(commit)) {
            return true;
        }
        this.commitMessageValidationHelper.performCommitMessageScanning(commit.getMessage(), commit.getDisplayId());
        return true;
    }

    private static boolean isMergeCommit(Commit commit) {
        return commit.getParents().size() > 1;
    }
}

