/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.hooks.jira;

import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.plugin.hooks.jira.ErrorMessageHelper;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SingleCommitErrorMessageHelper
extends ErrorMessageHelper {
    public SingleCommitErrorMessageHelper(I18nService i18nService) {
        super(i18nService);
    }

    @Override
    public RepositoryHookResult formatAndReturnHookRejectedResult(String detailMessage) {
        return RepositoryHookResult.rejected((String)this.printHookRejectedSummary(), (String)detailMessage);
    }

    @Override
    public String printAuthenticationRequiredMessage(@Nonnull String applinkName) {
        Objects.requireNonNull(applinkName, "applinkName");
        return this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.notauthenticated", new Object[]{applinkName});
    }

    @Override
    public String printTimeoutMessage() {
        return this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.timeout.ui.message", new Object[0]);
    }

    @Override
    public String printValidationErrors(@Nonnull List<String> validationErrors, @Nonnull Set<String> issueKeysToCheck) {
        Objects.requireNonNull(validationErrors, "validationErrors");
        Objects.requireNonNull(issueKeysToCheck, "issueKeysToCheck");
        return this.i18nService.getMessage("bitbucket.jira.commit.checker.hook.validationerrors.ui.message", new Object[]{StringUtils.join(issueKeysToCheck, (String)", ")});
    }
}

