/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.model;

import com.atlassian.bitbucket.internal.plugin.IssueValidationHookState;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class SimpleIssueValidationConfiguration
implements IssueValidationConfiguration {
    private final Set<String> exemptCommitMessages;
    private final Set<ApplicationUser> exemptPushers;
    private final IssueValidationHookState hookState;
    private final boolean ignoreMergeCommits;
    private final Scope scope;

    public SimpleIssueValidationConfiguration(Builder builder) {
        this.exemptCommitMessages = builder.exemptCommitMessages;
        this.exemptPushers = builder.exemptPushers;
        this.hookState = builder.hookState;
        this.ignoreMergeCommits = builder.ignoreMergeCommits;
        this.scope = builder.scope;
    }

    @Override
    @Nonnull
    public Set<String> getExemptCommitMessages() {
        return this.exemptCommitMessages;
    }

    @Override
    @Nonnull
    public Set<ApplicationUser> getExemptPushers() {
        return this.exemptPushers;
    }

    @Override
    @Nonnull
    public IssueValidationHookState getHookState() {
        return this.hookState;
    }

    @Override
    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public boolean shouldIgnoreMergeCommits() {
        return this.ignoreMergeCommits;
    }

    public static class Builder {
        private final Set<String> exemptCommitMessages;
        private final Set<ApplicationUser> exemptPushers;
        private final IssueValidationHookState hookState;
        private final boolean ignoreMergeCommits;
        private final Scope scope;

        public Builder(@Nonnull Set<String> exemptCommitMessages, @Nonnull Set<ApplicationUser> exemptPushers, @Nonnull IssueValidationHookState hookState, boolean ignoreMergeCommits, @Nonnull Scope scope) {
            this.exemptCommitMessages = Objects.requireNonNull(exemptCommitMessages, "exemptCommitMessages");
            this.exemptPushers = Objects.requireNonNull(exemptPushers, "exemptPushers");
            this.hookState = Objects.requireNonNull(hookState, "hookState");
            this.ignoreMergeCommits = ignoreMergeCommits;
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        @Nonnull
        public SimpleIssueValidationConfiguration build() {
            return new SimpleIssueValidationConfiguration(this);
        }
    }
}

