/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.rest;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.plugin.IssueValidationConfigurationService;
import com.atlassian.bitbucket.internal.plugin.IssueValidationConfigurationSetRequest;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import com.atlassian.bitbucket.internal.plugin.rest.RestIssueValidationConfiguration;
import com.atlassian.bitbucket.internal.plugin.rest.RestIssueValidationConfigurationRequest;
import com.atlassian.bitbucket.rest.v2.api.NotFoundException;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import jakarta.validation.Validator;
import jakarta.ws.rs.core.Response;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractIssueValidationConfigurationResource {
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final IssueValidationConfigurationService service;
    private final UserService userService;
    private final Validator validator;

    public AbstractIssueValidationConfigurationResource(FeatureManager featureManager, I18nService i18nService, IssueValidationConfigurationService service, UserService userService, Validator validator) {
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.service = service;
        this.userService = userService;
        this.validator = validator;
    }

    protected Response addOrUpdateConfiguration(Scope scope, RestIssueValidationConfigurationRequest request) {
        this.featureManager.requireEnabled((Feature)StandardFeature.JIRA_COMMIT_CHECKER);
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        return Response.ok((Object)((Object)new RestIssueValidationConfiguration(this.service.addOrUpdateConfiguration(scope, new IssueValidationConfigurationSetRequest.Builder(request.getHookState()).exemptPushers(this.getExemptPushers(request.getExemptPushers())).exemptCommitMessages(request.getExemptCommitMessages()).ignoreMergeCommits(request.shouldIgnoreMergeCommits()).build())))).build();
    }

    protected Response deleteConfiguration(Scope scope) {
        this.featureManager.requireEnabled((Feature)StandardFeature.JIRA_COMMIT_CHECKER);
        this.service.deleteConfiguration(scope);
        return Response.noContent().build();
    }

    protected Response getConfiguration(Scope scope) {
        this.featureManager.requireEnabled((Feature)StandardFeature.JIRA_COMMIT_CHECKER);
        return this.service.getConfiguration(scope).map(issueValidationConfiguration -> Response.ok((Object)((Object)new RestIssueValidationConfiguration((IssueValidationConfiguration)issueValidationConfiguration))).build()).orElseThrow(() -> new NotFoundException(this.i18nService.getMessage("bitbucket.jira.commit.checker.rest.configuration.not.found", new Object[0])));
    }

    private Set<ApplicationUser> getExemptPushers(Set<RestApplicationUser> users) {
        return users.stream().map(restUser -> {
            ApplicationUser user = this.userService.getUserById(restUser.getId());
            if (user == null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.jira.commit.checker.rest.configuration.exempt.pusher.invalid", new Object[]{restUser.getId(), restUser.getSlug()}));
            }
            return user;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

