/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.rest;

import com.atlassian.bitbucket.internal.plugin.IssueValidationHookState;
import com.atlassian.bitbucket.internal.plugin.model.IssueValidationConfiguration;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

@JsonSerialize
public class RestIssueValidationConfiguration
extends RestMapEntity {
    private static final String EXEMPT_COMMIT_MESSAGES = "exemptCommitMessages";
    private static final String EXEMPT_PUSHERS = "exemptPushers";
    private static final String HOOK_STATE = "hookState";
    private static final String IGNORE_MERGE_COMMITS = "ignoreMergeCommits";
    private static final String SCOPE = "scope";

    public RestIssueValidationConfiguration() {
    }

    public RestIssueValidationConfiguration(IssueValidationConfiguration configuration) {
        this(configuration.getHookState(), configuration.getExemptPushers(), configuration.getExemptCommitMessages(), configuration.shouldIgnoreMergeCommits(), configuration.getScope());
    }

    private RestIssueValidationConfiguration(IssueValidationHookState hookState, Set<ApplicationUser> exemptPushers, Set<String> exemptCommitMessages, boolean ignoreMergeCommits, Scope scope) {
        this.put(HOOK_STATE, (Object)hookState);
        this.put(EXEMPT_PUSHERS, RestIssueValidationConfiguration.toRestUsers(exemptPushers));
        this.put(EXEMPT_COMMIT_MESSAGES, exemptCommitMessages);
        this.put(IGNORE_MERGE_COMMITS, ignoreMergeCommits);
        this.put(SCOPE, new RestScope(scope));
    }

    public Collection<RestApplicationUser> getExemptPushers() {
        return (Collection)this.get(EXEMPT_PUSHERS);
    }

    private static Set<RestApplicationUser> toRestUsers(Set<ApplicationUser> users) {
        return users.stream().map(RestApplicationUser::new).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

