/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.plugin.rest;

import com.atlassian.bitbucket.internal.plugin.IssueValidationHookState;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
public class RestIssueValidationConfigurationRequest
extends RestMapEntity {
    private static final String EXEMPT_COMMIT_MESSAGES = "exemptCommitMessages";
    private static final String EXEMPT_PUSHERS = "exemptPushers";
    private static final String HOOK_STATE = "hookState";
    private static final String IGNORE_MERGE_COMMITS = "ignoreMergeCommits";

    public RestIssueValidationConfigurationRequest() {
    }

    private RestIssueValidationConfigurationRequest(IssueValidationHookState hookState, Set<RestApplicationUser> exemptPushers, Set<String> exemptCommitMessages, boolean ignoreMergeCommits) {
        this.put(HOOK_STATE, (Object)hookState);
        this.put(EXEMPT_COMMIT_MESSAGES, exemptCommitMessages);
        this.put(EXEMPT_PUSHERS, exemptPushers);
        this.put(IGNORE_MERGE_COMMITS, ignoreMergeCommits);
    }

    @Nonnull
    @Size(max=100, message="{bitbucket.jira.commit.checker.rest.configuration.exempt.commit.messages.toomany}")
    public @Size(max=100, message="{bitbucket.jira.commit.checker.rest.configuration.exempt.commit.messages.toomany}") Set<String> getExemptCommitMessages() {
        Object commitMessages = this.get(EXEMPT_COMMIT_MESSAGES);
        if (commitMessages instanceof List) {
            return ((List)commitMessages).stream().map(o -> {
                try {
                    return (String)o;
                }
                catch (ClassCastException e) {
                    return null;
                }
            }).map(StringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return Collections.emptySet();
    }

    @Nonnull
    @Size(max=100, message="{bitbucket.jira.commit.checker.rest.configuration.exempt.pushers.toomany}")
    public @Size(max=100, message="{bitbucket.jira.commit.checker.rest.configuration.exempt.pushers.toomany}") Set<RestApplicationUser> getExemptPushers() {
        Object users = this.get(EXEMPT_PUSHERS);
        if (users instanceof List) {
            return ((List)users).stream().map(RestApplicationUser::valueOf).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return Collections.emptySet();
    }

    @NotNull(message="{bitbucket.jira.commit.checker.rest.configuration.hook.state.required}")
    public @NotNull(message="{bitbucket.jira.commit.checker.rest.configuration.hook.state.required}") IssueValidationHookState getHookState() {
        return (IssueValidationHookState)this.getEnumProperty(HOOK_STATE, IssueValidationHookState.class, null);
    }

    public boolean shouldIgnoreMergeCommits() {
        return this.getBoolProperty(IGNORE_MERGE_COMMITS);
    }
}

